/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source.dialect.antlr4.mysql;

import java.util.HashSet;
import java.util.Set;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.connector.jdbc.antlr4.Antlr4DdlParser;
import org.apache.eventmesh.connector.jdbc.antlr4.autogeneration.MySqlLexer;
import org.apache.eventmesh.connector.jdbc.antlr4.autogeneration.MySqlParser;
import org.apache.eventmesh.connector.jdbc.antlr4.listener.Antlr4DdlParserListener;
import org.apache.eventmesh.connector.jdbc.ddl.DdlParserCallback;
import org.apache.eventmesh.connector.jdbc.event.Event;
import org.apache.eventmesh.connector.jdbc.source.config.JdbcSourceConfig;
import org.apache.eventmesh.connector.jdbc.source.dialect.antlr4.mysql.listener.MySqlAntlr4DdlParserListener;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;

public class MysqlAntlr4DdlParser
extends Antlr4DdlParser<MySqlLexer, MySqlParser> {
    private DdlParserCallback callback;
    private final Set<TableId> includeDatabaseTable;
    private final JdbcSourceConfig sourceConfig;

    public MysqlAntlr4DdlParser(boolean skipViews, boolean skipComments, Set<TableId> includeDatabaseTable, JdbcSourceConfig sourceConfig) {
        super(skipViews, skipComments);
        this.includeDatabaseTable = includeDatabaseTable;
        this.sourceConfig = sourceConfig;
    }

    public MysqlAntlr4DdlParser(boolean skipViews, boolean skipComments, JdbcSourceConfig sourceConfig) {
        this(skipViews, skipComments, new HashSet<TableId>(), sourceConfig);
    }

    @Override
    protected MySqlLexer buildLexerInstance(CharStream charStreams) {
        return new MySqlLexer(charStreams);
    }

    @Override
    protected MySqlParser buildParserInstance(CommonTokenStream commonTokenStream) {
        return new MySqlParser((TokenStream)commonTokenStream);
    }

    @Override
    protected ParseTree parseTree(MySqlParser parser) {
        return parser.root();
    }

    @Override
    protected Antlr4DdlParserListener createParseTreeWalkerListener(DdlParserCallback callback) {
        this.callback = callback;
        return new MySqlAntlr4DdlParserListener(this);
    }

    public void runIfAllNotNull(Runnable runner, Object ... nullableObjects) {
        if (nullableObjects == null || nullableObjects.length == 0) {
            runner.run();
        }
        for (Object nullableObject : nullableObjects) {
            if (nullableObject != null) continue;
            return;
        }
        runner.run();
    }

    public TableId parseTableId(String fullIdText) {
        String sanitizedText = StringUtils.replaceEach((String)fullIdText, (String[])new String[]{"'\\''", "\"", "`"}, (String[])new String[]{"", "", ""});
        String[] split = sanitizedText.split("\\.");
        TableId tableId = new TableId();
        if (split.length == 1) {
            tableId.setTableName(split[0]);
        } else {
            tableId.setCatalogName(split[0]);
            tableId.setTableName(split[1]);
        }
        return tableId;
    }

    public DdlParserCallback getCallback() {
        return this.callback;
    }

    public void handleEvent(Event event) {
        if (this.callback != null) {
            this.callback.handle(event);
        }
    }

    public boolean includeTableId(TableId tableId) {
        return this.includeDatabaseTable.contains(tableId);
    }

    public void addTableIdSet(Set<TableId> tableIdSet) {
        if (CollectionUtils.isEmpty(tableIdSet)) {
            return;
        }
        this.includeDatabaseTable.addAll(tableIdSet);
    }

    public JdbcSourceConfig getSourceConfig() {
        return this.sourceConfig;
    }
}

