/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source.dialect.mysql;

import com.mysql.cj.MysqlType;
import java.sql.JDBCType;
import java.util.Map;
import java.util.Objects;
import org.apache.eventmesh.connector.jdbc.DataTypeConvertor;
import org.apache.eventmesh.connector.jdbc.exception.DataTypeConvertException;
import org.apache.eventmesh.connector.jdbc.table.type.CalendarType;
import org.apache.eventmesh.connector.jdbc.table.type.DecimalType;
import org.apache.eventmesh.connector.jdbc.table.type.EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.table.type.PrimitiveByteArrayType;
import org.apache.eventmesh.connector.jdbc.table.type.PrimitiveType;
import org.apache.eventmesh.connector.jdbc.table.type.SQLType;

public class MysqlDataTypeConvertor
implements DataTypeConvertor<MysqlType> {
    public static final String PRECISION = "precision";
    public static final String SCALE = "scale";
    public static final Integer DEFAULT_PRECISION = 10;
    public static final Integer DEFAULT_SCALE = 0;

    @Override
    public JDBCType toJDBCType(String connectorDataType) {
        MysqlType mysqlType = MysqlType.getByName((String)connectorDataType);
        return JDBCType.valueOf(mysqlType.getJdbcType());
    }

    @Override
    public EventMeshDataType<?> toEventMeshType(String connectorDataType) throws DataTypeConvertException {
        MysqlType mysqlType = MysqlType.getByName((String)connectorDataType);
        return this.toEventMeshType(mysqlType, (Map<String, Object>)null);
    }

    @Override
    public EventMeshDataType<?> toEventMeshType(JDBCType jdbcType, Map<String, Object> dataTypeProperties) throws DataTypeConvertException {
        return this.toEventMeshType(MysqlType.getByJdbcType((int)jdbcType.getVendorTypeNumber()), dataTypeProperties);
    }

    @Override
    public EventMeshDataType<?> toEventMeshType(MysqlType connectorDataType, Map<String, Object> dataTypeProperties) throws DataTypeConvertException {
        Objects.requireNonNull(connectorDataType, "MysqlType can't be null");
        switch (connectorDataType) {
            case NULL: {
                return PrimitiveType.VOID_TYPE;
            }
            case BOOLEAN: {
                return PrimitiveType.BOOLEAN_TYPE;
            }
            case BIT: {
                if (null == dataTypeProperties) {
                    return PrimitiveByteArrayType.BYTES_TYPE;
                }
                Integer precision = (Integer)dataTypeProperties.get(PRECISION);
                if (precision != null && precision == 1) {
                    return PrimitiveType.BOOLEAN_TYPE;
                }
                return PrimitiveByteArrayType.BYTES_TYPE;
            }
            case TINYINT: {
                return PrimitiveType.BYTE_TYPE;
            }
            case TINYINT_UNSIGNED: 
            case SMALLINT: {
                return PrimitiveType.SHORT_TYPE;
            }
            case SMALLINT_UNSIGNED: 
            case INT: 
            case MEDIUMINT: 
            case MEDIUMINT_UNSIGNED: {
                return PrimitiveType.INT_TYPE;
            }
            case INT_UNSIGNED: 
            case BIGINT: {
                return PrimitiveType.LONG_TYPE;
            }
            case FLOAT: 
            case FLOAT_UNSIGNED: {
                return PrimitiveType.FLOAT_TYPE;
            }
            case DOUBLE: 
            case DOUBLE_UNSIGNED: {
                return PrimitiveType.DOUBLE_TYPE;
            }
            case TIME: {
                return CalendarType.LOCAL_TIME_TYPE;
            }
            case YEAR: 
            case DATE: {
                return CalendarType.LOCAL_DATE_TYPE;
            }
            case TIMESTAMP: 
            case DATETIME: {
                return CalendarType.LOCAL_DATE_TIME_TYPE;
            }
            case CHAR: 
            case VARCHAR: 
            case TINYTEXT: 
            case TEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: 
            case JSON: 
            case ENUM: {
                return PrimitiveType.STRING_TYPE;
            }
            case BINARY: 
            case VARBINARY: 
            case TINYBLOB: 
            case BLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: 
            case GEOMETRY: {
                return PrimitiveByteArrayType.BYTES_TYPE;
            }
            case BIGINT_UNSIGNED: 
            case DECIMAL: 
            case DECIMAL_UNSIGNED: {
                if (dataTypeProperties == null) {
                    return new DecimalType(DEFAULT_PRECISION, DEFAULT_SCALE);
                }
                Integer precision = (Integer)dataTypeProperties.getOrDefault(PRECISION, DEFAULT_PRECISION);
                Integer scale = (Integer)dataTypeProperties.getOrDefault(SCALE, DEFAULT_SCALE);
                return new DecimalType(precision, scale);
            }
        }
        throw new DataTypeConvertException(String.format("%s type is not supported", connectorDataType.getName()));
    }

    @Override
    public MysqlType toConnectorType(EventMeshDataType<?> eventMeshDataType, Map<String, Object> dataTypeProperties) throws DataTypeConvertException {
        Objects.requireNonNull(eventMeshDataType, "Parameter eventMeshDataType can not be null");
        SQLType sqlType = eventMeshDataType.getSQLType();
        switch (sqlType) {
            case BOOLEAN: {
                return MysqlType.BOOLEAN;
            }
            case TINYINT: {
                return MysqlType.TINYINT;
            }
            case SMALLINT: {
                return MysqlType.SMALLINT;
            }
            case INTEGER: {
                return MysqlType.INT;
            }
            case BIGINT: {
                return MysqlType.BIGINT;
            }
            case FLOAT: {
                return MysqlType.FLOAT;
            }
            case DOUBLE: {
                return MysqlType.DOUBLE;
            }
            case DECIMAL: {
                return MysqlType.DECIMAL;
            }
            case NULL: {
                return MysqlType.NULL;
            }
            case BINARY: {
                return MysqlType.BIT;
            }
            case DATE: {
                return MysqlType.DATE;
            }
            case TIME: {
                return MysqlType.DATETIME;
            }
            case TIMESTAMP: {
                return MysqlType.TIMESTAMP;
            }
            case ARRAY: 
            case MAP: 
            case ROW: 
            case STRING: {
                return MysqlType.VARCHAR;
            }
        }
        throw new DataTypeConvertException(String.format("%s type is not supported", sqlType.name()));
    }
}

