/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source.dialect.mysql;

import com.mysql.cj.MysqlType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.common.utils.LogUtils;
import org.apache.eventmesh.connector.jdbc.DataTypeConvertor;
import org.apache.eventmesh.connector.jdbc.JdbcDriverMetaData;
import org.apache.eventmesh.connector.jdbc.connection.mysql.MysqlJdbcConnection;
import org.apache.eventmesh.connector.jdbc.exception.CatalogException;
import org.apache.eventmesh.connector.jdbc.exception.DatabaseNotExistException;
import org.apache.eventmesh.connector.jdbc.exception.TableNotExistException;
import org.apache.eventmesh.connector.jdbc.source.config.JdbcSourceConfig;
import org.apache.eventmesh.connector.jdbc.source.config.SourceConnectorConfig;
import org.apache.eventmesh.connector.jdbc.source.dialect.AbstractGeneralDatabaseDialect;
import org.apache.eventmesh.connector.jdbc.source.dialect.mysql.MysqlDataTypeConvertor;
import org.apache.eventmesh.connector.jdbc.source.dialect.mysql.MysqlDialectSql;
import org.apache.eventmesh.connector.jdbc.table.catalog.CatalogTable;
import org.apache.eventmesh.connector.jdbc.table.catalog.DefaultColumn;
import org.apache.eventmesh.connector.jdbc.table.catalog.PrimaryKey;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlDatabaseDialect
extends AbstractGeneralDatabaseDialect<MysqlJdbcConnection> {
    private static final Logger log = LoggerFactory.getLogger(MysqlDatabaseDialect.class);
    private MysqlJdbcConnection connection;
    private DataTypeConvertor<MysqlType> dataTypeConvertor = new MysqlDataTypeConvertor();
    private SourceConnectorConfig config;

    public MysqlDatabaseDialect(JdbcSourceConfig config) {
        super(config.getSourceConnectorConfig());
        this.config = config.getSourceConnectorConfig();
    }

    @Override
    public void init() {
        boolean initSuccess;
        do {
            try {
                this.connection = this.initJdbcConnection();
                initSuccess = true;
            }
            catch (Exception e) {
                log.error("Init jdbc connection error,The connection will be retried in three seconds", (Throwable)e);
                initSuccess = false;
                try {
                    TimeUnit.SECONDS.sleep(3L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        } while (!initSuccess);
    }

    @Override
    public void start() {
    }

    private MysqlJdbcConnection initJdbcConnection() {
        try {
            return new MysqlJdbcConnection(this.config.getJdbcConfig(), null, false);
        }
        catch (Exception e) {
            throw new CatalogException(e);
        }
    }

    @Override
    public void open() throws CatalogException {
    }

    @Override
    public String getDefaultDatabase() {
        return null;
    }

    @Override
    public boolean databaseExists(String databaseName) throws CatalogException {
        if (null == databaseName || databaseName.trim().isEmpty()) {
            return false;
        }
        List<String> databases = this.listDatabases();
        return databases.contains(databaseName);
    }

    @Override
    public List<String> listDatabases() throws CatalogException {
        ArrayList<String> databases = new ArrayList<String>(16);
        try {
            this.connection.query(MysqlDialectSql.SHOW_DATABASE.ofSQL(), resultSet -> {
                while (resultSet.next()) {
                    databases.add(resultSet.getString("Database"));
                }
            });
        }
        catch (SQLException e) {
            log.error("List Mysql database error", (Throwable)e);
            throw new CatalogException(e);
        }
        return databases;
    }

    @Override
    public List<TableId> listTables(String databaseName) throws CatalogException, DatabaseNotExistException, SQLException {
        ArrayList<TableId> tableIds = new ArrayList<TableId>(32);
        String sql = MysqlDialectSql.SHOW_DATABASE_TABLE.ofWrapperSQL("`" + databaseName + "`");
        LogUtils.debug((Logger)log, (String)"List tables SQL:{}", (Object)sql);
        this.connection.query(sql, resultSet -> {
            while (resultSet.next()) {
                TableId tableId = new TableId(databaseName, null, resultSet.getString(1));
                tableIds.add(tableId);
            }
        });
        return tableIds;
    }

    @Override
    public boolean tableExists(TableId tableId) throws CatalogException, SQLException {
        List<TableId> tableIds = this.listTables(tableId.getCatalogName());
        return tableIds.contains(tableId);
    }

    @Override
    public CatalogTable getTable(TableId tableId) throws CatalogException, TableNotExistException, SQLException {
        Objects.requireNonNull(tableId, "TableId is null");
        if (!this.tableExists(tableId)) {
            log.error("Table {} not exist in database", (Object)tableId);
            throw new CatalogException(String.format("Table %s not exist in database", tableId));
        }
        CatalogTable table = new CatalogTable();
        table.setTableId(tableId);
        TableSchema tableSchema = new TableSchema();
        table.setTableSchema(tableSchema);
        String createTableSql = MysqlDialectSql.SHOW_CREATE_TABLE.ofWrapperSQL(tableId.getId());
        LogUtils.debug((Logger)log, (String)"Show create table SQL:{}", (Object)createTableSql);
        this.connection.query(createTableSql, resultSet -> {
            boolean hasNext = resultSet.next();
            if (!hasNext) {
                throw new CatalogException(String.format("Table %s not exist in database", tableId.getId()));
            }
            String creatTableSql = resultSet.getString("Create Table");
        });
        String selectTableSql = MysqlDialectSql.SELECT_TABLE_COLUMNS.ofWrapperSQL(tableId.getId());
        LogUtils.debug((Logger)log, (String)"Select table SQL:{}", (Object)selectTableSql);
        HashMap columns = new HashMap(16);
        this.connection.query(selectTableSql, resultSet -> {
            ResultSetMetaData tableMetaData = resultSet.getMetaData();
            int columnCount = tableMetaData.getColumnCount();
            for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                String columnName = tableMetaData.getColumnName(columnIndex);
                DefaultColumn column = columns.computeIfAbsent(columnName, key -> new DefaultColumn());
                column.setName(columnName);
                int precision = tableMetaData.getPrecision(columnIndex);
                column.setColumnLength(precision);
                HashMap<String, Object> dataTypeProperties = new HashMap<String, Object>();
                dataTypeProperties.put("precision", precision);
                int scale = tableMetaData.getScale(columnIndex);
                dataTypeProperties.put("scale", scale);
                column.setDataType(this.dataTypeConvertor.toEventMeshType(MysqlType.getByJdbcType((int)tableMetaData.getColumnType(columnIndex)), dataTypeProperties));
                column.setDecimal(scale);
            }
        });
        String showTableSql = MysqlDialectSql.SHOW_TABLE_COLUMNS.ofWrapperSQL(tableId.getTableName(), tableId.getCatalogName());
        LogUtils.debug((Logger)log, (String)"Show table columns SQL:{}", (Object)showTableSql);
        ArrayList columnList = new ArrayList(columns.size());
        this.connection.query(showTableSql, resultSet -> {
            boolean hasNext = resultSet.next();
            if (!hasNext) {
                throw new CatalogException(String.format("Table %s without columns", tableId.getId()));
            }
            ArrayList<String> columnNames = new ArrayList<String>(4);
            do {
                String field = resultSet.getString("Field");
                DefaultColumn column = (DefaultColumn)columns.get(field);
                String comment = resultSet.getString("Comment");
                column.setComment(comment);
                String enableNull = resultSet.getString("Null");
                column.setNotNull("NO".equalsIgnoreCase(enableNull));
                String type = resultSet.getString("Type");
                Object defaultValue = resultSet.getObject("Default");
                column.setDefaultValue(defaultValue);
                String key = resultSet.getString("Key");
                if ("PRI".equalsIgnoreCase(key)) {
                    columnNames.add(field);
                }
                columnList.add(column);
            } while (resultSet.next());
            tableSchema.setColumns(columnList);
            tableSchema.setColumnMap(columns);
            if (!columnNames.isEmpty()) {
                tableSchema.setPrimaryKey(new PrimaryKey(columnNames));
            }
        });
        return table;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public PreparedStatement createPreparedStatement(Connection connection, String sql) throws SQLException {
        Objects.requireNonNull(connection, "Connection is null");
        Objects.requireNonNull(sql, "SQL is null");
        return connection.prepareStatement(sql);
    }

    @Override
    public JdbcDriverMetaData getJdbcDriverMetaData() {
        return this.connection.getJdbcDriverMetaData();
    }

    @Override
    public String jdbcProtocol() {
        return "jdbc:mysql://%s:%s/?useInformationSchema=true&nullCatalogMeansCurrent=false&useUnicode=true&characterEncoding=UTF-8&characterSetResults=UTF-8&zeroDateTimeBehavior=CONVERT_TO_NULL&connectTimeout=%s";
    }

    @Override
    public MysqlJdbcConnection getConnection() {
        return this.connection;
    }

    @Override
    public MysqlJdbcConnection newConnection() {
        return this.initJdbcConnection();
    }

    @Override
    public void close() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }
}

