/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source.dialect.mysql;

import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.connector.jdbc.PartitionOffSetContextPair;
import org.apache.eventmesh.connector.jdbc.UniversalJdbcContext;
import org.apache.eventmesh.connector.jdbc.context.mysql.MysqlOffsetContext;
import org.apache.eventmesh.connector.jdbc.context.mysql.MysqlPartition;
import org.apache.eventmesh.connector.jdbc.source.config.JdbcSourceConfig;
import org.apache.eventmesh.connector.jdbc.source.config.SourceConnectorConfig;
import org.apache.eventmesh.connector.jdbc.source.dialect.antlr4.mysql.MysqlAntlr4DdlParser;
import org.apache.eventmesh.connector.jdbc.source.dialect.mysql.MysqlSourceInfo;

public class MysqlJdbcContext
extends UniversalJdbcContext<MysqlPartition, MysqlOffsetContext, MysqlAntlr4DdlParser> {
    private MysqlSourceInfo sourceInfo = new MysqlSourceInfo();
    private volatile long currentHandleEventSize = 0L;
    private volatile boolean onTransaction = false;
    private String restartGtidSet;
    private String currentGtidSet;
    private String restartBinlogFilename;
    private long restartBinlogPosition;
    private String transactionId;
    private JdbcSourceConfig jdbcSourceConfig;

    public MysqlJdbcContext(PartitionOffSetContextPair<MysqlPartition, MysqlOffsetContext> poCtx, MysqlAntlr4DdlParser parser) {
        super(poCtx, parser);
    }

    public MysqlJdbcContext(MysqlPartition mysqlPartition, MysqlOffsetContext mysqlOffsetContext, MysqlAntlr4DdlParser parser) {
        super(mysqlPartition, mysqlOffsetContext, parser);
    }

    public MysqlJdbcContext(JdbcSourceConfig jdbcSourceConfig, MysqlAntlr4DdlParser parser) {
        this(new MysqlPartition(), new MysqlOffsetContext(), parser);
        this.jdbcSourceConfig = jdbcSourceConfig;
    }

    public void setBinlogStartPoint(String binlogFilename, long beginProcessPosition) {
        assert (beginProcessPosition >= 0L);
        if (binlogFilename != null) {
            this.sourceInfo.setBinlogPosition(binlogFilename, beginProcessPosition);
        } else {
            this.sourceInfo.setBinlogPosition(this.sourceInfo.getCurrentBinlogFileName(), beginProcessPosition);
        }
    }

    public void setEventPosition(long positionOfCurrentEvent, long eventSize) {
        this.sourceInfo.setCurrentBinlogPosition(positionOfCurrentEvent);
        this.currentHandleEventSize = eventSize;
    }

    public static MysqlJdbcContext initialize(JdbcSourceConfig jdbcSourceConfig) {
        SourceConnectorConfig sourceConnectorConfig = jdbcSourceConfig.getSourceConnectorConfig();
        MysqlAntlr4DdlParser mysqlAntlr4DdlParser = new MysqlAntlr4DdlParser(sourceConnectorConfig.isSkipViews(), sourceConnectorConfig.isSkipComments(), jdbcSourceConfig);
        return new MysqlJdbcContext(new MysqlPartition(), new MysqlOffsetContext(), mysqlAntlr4DdlParser);
    }

    public void startTransaction() {
        this.onTransaction = true;
    }

    public void commitTransaction() {
        this.onTransaction = false;
        this.restartGtidSet = this.currentGtidSet;
        this.restartBinlogFilename = this.sourceInfo.getCurrentBinlogFileName();
        this.restartBinlogPosition = this.sourceInfo.getCurrentBinlogPosition() + this.currentHandleEventSize;
        this.resetTransactionId();
    }

    public void complete() {
        this.currentHandleEventSize = 0L;
    }

    public void completedGtidSet(String gtidSet) {
        if (StringUtils.isNotBlank((CharSequence)gtidSet)) {
            String trimmedGtidSet;
            this.currentGtidSet = trimmedGtidSet = gtidSet.replace("\n", "").replace("\r", "");
            this.restartGtidSet = trimmedGtidSet;
        }
    }

    public String getGtidSet() {
        return this.currentGtidSet;
    }

    public void beginGtid(String gtid) {
        this.sourceInfo.beginGtid(gtid);
    }

    private void resetTransactionId() {
        this.transactionId = null;
    }

    public MysqlSourceInfo getSourceInfo() {
        return this.sourceInfo;
    }
}

