/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.table.catalog;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableSchema;

public final class CatalogTableSet {
    private final TableIdSet tableIdSet = new TableIdSet();
    private final TableSchemaMap tableSchemaMap = new TableSchemaMap();

    public void removeDatabase(String catalogName) {
        this.removeDatabase(catalogName, null);
    }

    public void removeDatabase(String catalogName, String schemaName) {
        this.tableSchemaMap.removeDatabase(catalogName, schemaName);
        this.tableIdSet.removeDatabase(catalogName, schemaName);
    }

    public void overrideTable(TableSchema tableSchema) {
        if (tableSchema == null || tableSchema.getTableId() == null) {
            return;
        }
        this.tableSchemaMap.putTableSchema(tableSchema);
    }

    public TableSchema getTableSchema(TableId tableId) {
        return this.tableSchemaMap.getTableSchema(tableId);
    }

    private static class TableSchemaMap {
        private final ConcurrentMap<TableId, TableSchema> values = new ConcurrentHashMap<TableId, TableSchema>(32);

        public void removeDatabase(String catalogName, String schemaName) {
            this.values.entrySet().removeIf(entry -> {
                TableId key = (TableId)entry.getKey();
                return StringUtils.equals((CharSequence)key.getCatalogName(), (CharSequence)catalogName) && StringUtils.equals((CharSequence)key.getSchemaName(), (CharSequence)schemaName);
            });
        }

        public TableSchema getTableSchema(TableId tableId) {
            return (TableSchema)this.values.get(tableId);
        }

        public TableSchema putTableSchema(TableSchema tableSchema) {
            return this.values.put(tableSchema.getTableId(), tableSchema);
        }
    }

    private static class TableIdSet {
        private final Set<TableId> values = new HashSet<TableId>(32);

        public void removeDatabase(String catalogName, String schemaName) {
            this.values.removeIf(entry -> StringUtils.equals((CharSequence)entry.getCatalogName(), (CharSequence)catalogName) && StringUtils.equals((CharSequence)entry.getSchemaName(), (CharSequence)schemaName));
        }
    }
}

