/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.table.catalog;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class TableId
implements Serializable {
    public static final TableIdToStringMapper DEFAULT_TABLEIDTOSTRINGMAPPER = new DefaultTableIdToStringMapper();
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String id;

    public TableId() {
    }

    public TableId(String catalogName, String schemaName, String tableName) {
        this(catalogName, schemaName, tableName, null);
    }

    public TableId(String catalogName) {
        this(catalogName, null, null, null);
    }

    public TableId(String catalogName, String schemaName, String tableName, TableIdToStringMapper mapper) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.id = mapper == null ? DEFAULT_TABLEIDTOSTRINGMAPPER.toString(this) : mapper.toString(this);
    }

    public String toString() {
        return this.id == null ? DEFAULT_TABLEIDTOSTRINGMAPPER.toString(this) : this.id;
    }

    public String tablePath() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableId)) {
            return false;
        }
        TableId tableId = (TableId)o;
        return Objects.equals(this.getCatalogName(), tableId.getCatalogName()) && Objects.equals(this.getSchemaName(), tableId.getSchemaName()) && Objects.equals(this.getTableName(), tableId.getTableName());
    }

    public int hashCode() {
        return Objects.hash(this.getCatalogName(), this.getSchemaName(), this.getTableName());
    }

    private static String tableId(String catalog, String schema, String table) {
        StringBuilder tableId = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            tableId.append(catalog).append(".");
        }
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            tableId.append(schema).append(".");
        }
        if (StringUtils.isNotBlank((CharSequence)table)) {
            tableId.append(table).append(".");
        }
        if (tableId.length() == 0) {
            return null;
        }
        return tableId.substring(0, tableId.length() - 1);
    }

    public TableId copy() {
        return new TableId(this.catalogName, this.schemaName, this.tableName);
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getId() {
        return this.id;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setId(String id) {
        this.id = id;
    }

    private static class DefaultTableIdToStringMapper
    implements TableIdToStringMapper {
        private DefaultTableIdToStringMapper() {
        }

        @Override
        public String toString(TableId tableId) {
            return TableId.tableId(tableId.getCatalogName(), tableId.getSchemaName(), tableId.getTableName());
        }
    }

    @FunctionalInterface
    public static interface TableIdToStringMapper {
        public String toString(TableId var1);
    }
}

