/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.table.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;
import org.apache.eventmesh.connector.jdbc.table.type.RowHandleMode;

public class EventMeshRow
implements Serializable {
    private RowHandleMode mode = RowHandleMode.INSERT;
    private TableId tableId;
    private final Object[] fieldValues;
    private Map<String, ?> ext = new HashMap();

    public EventMeshRow(int fieldNum) {
        this.fieldValues = new Object[fieldNum];
    }

    public EventMeshRow(int fieldNum, TableId tableId) {
        this.tableId = tableId;
        this.fieldValues = new Object[fieldNum];
    }

    public EventMeshRow(RowHandleMode mode, int fieldNum, TableId tableId) {
        this.mode = mode;
        this.tableId = tableId;
        this.fieldValues = new Object[fieldNum];
    }

    public void setFieldValues(Object[] fieldValues) {
        Objects.requireNonNull(fieldValues, "Parameter fields can not be null");
        if (this.fieldValues.length != fieldValues.length) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(fieldValues, 0, this.fieldValues, 0, this.fieldValues.length);
    }

    public RowHandleMode getMode() {
        return this.mode;
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public Object[] getFieldValues() {
        return this.fieldValues;
    }

    public Map<String, ?> getExt() {
        return this.ext;
    }

    public void setMode(RowHandleMode mode) {
        this.mode = mode;
    }

    public void setTableId(TableId tableId) {
        this.tableId = tableId;
    }

    public void setExt(Map<String, ?> ext) {
        this.ext = ext;
    }
}

