/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.table.type;

import java.util.Objects;
import org.apache.eventmesh.connector.jdbc.table.type.EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.table.type.PrimitiveType;
import org.apache.eventmesh.connector.jdbc.table.type.SQLType;

public class PrimitiveArrayType<E, T>
implements EventMeshDataType<T> {
    public static final PrimitiveArrayType<String[], String> STRING_ARRAY_TYPE = new PrimitiveArrayType<String, String[]>(String[].class, PrimitiveType.STRING_TYPE);
    public static final PrimitiveArrayType<Boolean[], Boolean> BOOLEAN_ARRAY_TYPE = new PrimitiveArrayType<Boolean, Boolean[]>(Boolean[].class, PrimitiveType.BOOLEAN_TYPE);
    public static final PrimitiveArrayType<Byte[], Byte> BYTE_ARRAY_TYPE = new PrimitiveArrayType<Byte, Byte[]>(Byte[].class, PrimitiveType.BYTE_TYPE);
    public static final PrimitiveArrayType<Short[], Short> SHORT_ARRAY_TYPE = new PrimitiveArrayType<Short, Short[]>(Short[].class, PrimitiveType.SHORT_TYPE);
    public static final PrimitiveArrayType<Integer[], Integer> INT_ARRAY_TYPE = new PrimitiveArrayType<Integer, Integer[]>(Integer[].class, PrimitiveType.INT_TYPE);
    public static final PrimitiveArrayType<Long[], Long> LONG_ARRAY_TYPE = new PrimitiveArrayType<Long, Long[]>(Long[].class, PrimitiveType.LONG_TYPE);
    public static final PrimitiveArrayType<Float[], Float> FLOAT_ARRAY_TYPE = new PrimitiveArrayType<Float, Float[]>(Float[].class, PrimitiveType.FLOAT_TYPE);
    public static final PrimitiveArrayType<Double[], Double> DOUBLE_ARRAY_TYPE = new PrimitiveArrayType<Double, Double[]>(Double[].class, PrimitiveType.DOUBLE_TYPE);
    private final Class<T> typeClass;
    private final PrimitiveType<E> sqlType;

    private PrimitiveArrayType(Class<T> arrayClass, PrimitiveType<E> elementType) {
        this.typeClass = arrayClass;
        this.sqlType = elementType;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    @Override
    public SQLType getSQLType() {
        return SQLType.ARRAY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrimitiveArrayType)) {
            return false;
        }
        PrimitiveArrayType that = (PrimitiveArrayType)o;
        return Objects.equals(this.getTypeClass(), that.getTypeClass()) && Objects.equals(this.sqlType, that.sqlType);
    }

    public int hashCode() {
        return Objects.hash(this.getTypeClass(), this.sqlType);
    }

    public String toString() {
        return this.typeClass.getName();
    }
}

