/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.table.type;

import java.util.Objects;
import org.apache.eventmesh.connector.jdbc.table.type.EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.table.type.SQLType;

public class PrimitiveType<T>
implements EventMeshDataType<T> {
    public static final PrimitiveType<String> STRING_TYPE = new PrimitiveType<String>(String.class, SQLType.STRING);
    public static final PrimitiveType<Boolean> BOOLEAN_TYPE = new PrimitiveType<Boolean>(Boolean.class, SQLType.BOOLEAN);
    public static final PrimitiveType<Byte> BYTE_TYPE = new PrimitiveType<Byte>(Byte.class, SQLType.TINYINT);
    public static final PrimitiveType<Short> SHORT_TYPE = new PrimitiveType<Short>(Short.class, SQLType.SMALLINT);
    public static final PrimitiveType<Integer> INT_TYPE = new PrimitiveType<Integer>(Integer.class, SQLType.INTEGER);
    public static final PrimitiveType<Long> LONG_TYPE = new PrimitiveType<Long>(Long.class, SQLType.BIGINT);
    public static final PrimitiveType<Float> FLOAT_TYPE = new PrimitiveType<Float>(Float.class, SQLType.FLOAT);
    public static final PrimitiveType<Double> DOUBLE_TYPE = new PrimitiveType<Double>(Double.class, SQLType.DOUBLE);
    public static final PrimitiveType<Void> VOID_TYPE = new PrimitiveType<Void>(Void.class, SQLType.NULL);
    private final Class<T> typeClass;
    private final SQLType sqlType;

    public PrimitiveType(Class<T> typeClass, SQLType sqlType) {
        this.typeClass = typeClass;
        this.sqlType = sqlType;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    @Override
    public SQLType getSQLType() {
        return this.sqlType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrimitiveType)) {
            return false;
        }
        PrimitiveType that = (PrimitiveType)o;
        return Objects.equals(this.getTypeClass(), that.getTypeClass()) && this.sqlType == that.sqlType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getTypeClass(), this.sqlType});
    }

    public String toString() {
        return this.typeClass.getName();
    }
}

