/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.lark.sink;

import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.lark.oapi.Client;
import com.lark.oapi.card.enums.MessageCardHeaderTemplateEnum;
import com.lark.oapi.card.model.MessageCard;
import com.lark.oapi.card.model.MessageCardConfig;
import com.lark.oapi.card.model.MessageCardElement;
import com.lark.oapi.card.model.MessageCardHeader;
import com.lark.oapi.card.model.MessageCardMarkdown;
import com.lark.oapi.card.model.MessageCardPlainText;
import com.lark.oapi.core.httpclient.IHttpTransport;
import com.lark.oapi.core.httpclient.OkHttpTransport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.utils.Lists;
import com.lark.oapi.okhttp.OkHttpClient;
import com.lark.oapi.service.im.v1.ImService;
import com.lark.oapi.service.im.v1.enums.MsgTypeEnum;
import com.lark.oapi.service.im.v1.model.CreateMessageReq;
import com.lark.oapi.service.im.v1.model.CreateMessageReqBody;
import com.lark.oapi.service.im.v1.model.CreateMessageResp;
import com.lark.oapi.service.im.v1.model.ext.MessageText;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.eventmesh.connector.lark.config.LarkMessageTemplateType;
import org.apache.eventmesh.connector.lark.sink.config.SinkConnectorConfig;
import org.apache.eventmesh.connector.lark.sink.connector.LarkSinkConnector;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImServiceHandler {
    private static final Logger log = LoggerFactory.getLogger(ImServiceHandler.class);
    private SinkConnectorConfig sinkConnectorConfig;
    private ImService imService;
    private Retryer<ConnectRecord> retryer;
    private ExecutorService sinkAsyncWorker;
    private ExecutorService cleanerWorker;
    private ScheduledExecutorService retryWorker;
    private static final LongAdder redoSinkNum = new LongAdder();

    public static ImServiceHandler create(SinkConnectorConfig sinkConnectorConfig) {
        ImServiceHandler imServiceHandler = new ImServiceHandler();
        imServiceHandler.sinkConnectorConfig = sinkConnectorConfig;
        imServiceHandler.imService = Client.newBuilder((String)sinkConnectorConfig.getAppId(), (String)sinkConnectorConfig.getAppSecret()).httpTransport((IHttpTransport)new OkHttpTransport(new OkHttpClient().newBuilder().callTimeout(3L, TimeUnit.SECONDS).build())).disableTokenCache().requestTimeout(3L, TimeUnit.SECONDS).build().im();
        long fixedWait = Long.parseLong(sinkConnectorConfig.getRetryDelayInMills());
        int maxRetryTimes = Integer.parseInt(sinkConnectorConfig.getMaxRetryTimes()) + 1;
        if (Boolean.parseBoolean(sinkConnectorConfig.getSinkAsync())) {
            int availableProcessors = Runtime.getRuntime().availableProcessors();
            imServiceHandler.sinkAsyncWorker = Executors.newFixedThreadPool(availableProcessors, r -> {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                thread.setName("eventmesh-connector-lark-sinkAsyncWorker");
                return thread;
            });
            imServiceHandler.cleanerWorker = Executors.newFixedThreadPool(availableProcessors, r -> {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                thread.setName("eventmesh-connector-lark-cleanerWorker");
                return thread;
            });
            imServiceHandler.retryWorker = Executors.newScheduledThreadPool(availableProcessors, r -> {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                thread.setName("eventmesh-connector-lark-retryWorker");
                return thread;
            });
        } else {
            imServiceHandler.retryer = RetryerBuilder.newBuilder().retryIfException().retryIfResult(Objects::nonNull).withWaitStrategy(WaitStrategies.fixedWait((long)fixedWait, (TimeUnit)TimeUnit.MILLISECONDS)).withStopStrategy(StopStrategies.stopAfterAttempt((int)maxRetryTimes)).withRetryListener(new RetryListener(){

                public <V> void onRetry(Attempt<V> attempt) {
                    long times = attempt.getAttemptNumber();
                    if (times > 1L) {
                        redoSinkNum.increment();
                        log.info("Total redo sink task num : [{}]", (Object)redoSinkNum.sum());
                        log.warn("Retry sink event to lark | times=[{}]", (Object)(attempt.getAttemptNumber() - 1L));
                    }
                }
            }).build();
        }
        return imServiceHandler;
    }

    public void sink(ConnectRecord connectRecord) throws ExecutionException, RetryException {
        HashMap<String, ArrayList> headers = new HashMap<String, ArrayList>();
        headers.put("Content-Type", Lists.newArrayList((Object[])new String[]{"application/json; charset=utf-8"}));
        RequestOptions requestOptions = RequestOptions.newBuilder().tenantAccessToken(LarkSinkConnector.getTenantAccessToken(this.sinkConnectorConfig.getAppId(), this.sinkConnectorConfig.getAppSecret())).headers(headers).build();
        this.retryer.call(() -> {
            CreateMessageReq createMessageReq = this.convertCreateMessageReq(connectRecord);
            CreateMessageResp resp = this.imService.message().create(createMessageReq, requestOptions);
            if (resp.getCode() != 0) {
                log.warn("Sinking event to lark failure | code:[{}] | msg:[{}] | err:[{}]", new Object[]{resp.getCode(), resp.getMsg(), resp.getError()});
                return connectRecord;
            }
            return null;
        });
    }

    public void sinkAsync(ConnectRecord connectRecord) {
        HashMap<String, ArrayList> headers = new HashMap<String, ArrayList>();
        headers.put("Content-Type", Lists.newArrayList((Object[])new String[]{"application/json; charset=utf-8"}));
        RequestOptions requestOptions = RequestOptions.newBuilder().tenantAccessToken(LarkSinkConnector.getTenantAccessToken(this.sinkConnectorConfig.getAppId(), this.sinkConnectorConfig.getAppSecret())).headers(headers).build();
        CreateMessageReq createMessageReq = this.convertCreateMessageReq(connectRecord);
        long fixedWait = Long.parseLong(this.sinkConnectorConfig.getRetryDelayInMills());
        int maxRetryTimes = Integer.parseInt(this.sinkConnectorConfig.getMaxRetryTimes()) + 1;
        LongAdder cnt = new LongAdder();
        AtomicBoolean isAck = new AtomicBoolean(false);
        Runnable task = () -> CompletableFuture.supplyAsync(() -> {
            try {
                cnt.increment();
                return this.imService.message().create(createMessageReq, requestOptions);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, this.sinkAsyncWorker).whenCompleteAsync((resp, e) -> {
            if (cnt.sum() > 1L) {
                redoSinkNum.increment();
                log.info("Total redo sink task num : [{}]", (Object)redoSinkNum.sum());
                log.warn("Retry sink event to lark | times=[{}]", (Object)(cnt.sum() - 1L));
            }
            if (Objects.nonNull(e)) {
                log.error("eventmesh-connector-lark internal exception.", e);
                return;
            }
            if (resp.getCode() != 0) {
                log.warn("Sinking event to lark failure | code:[{}] | msg:[{}] | err:[{}]", new Object[]{resp.getCode(), resp.getMsg(), resp.getError()});
                return;
            }
            isAck.set(true);
        });
        ScheduledFuture<?> future = this.retryWorker.scheduleAtFixedRate(task, 0L, fixedWait, TimeUnit.MILLISECONDS);
        this.cleanerWorker.submit(() -> {
            while (!isAck.get() && cnt.sum() < (long)maxRetryTimes) {
            }
            future.cancel(true);
        });
    }

    private CreateMessageReq convertCreateMessageReq(ConnectRecord connectRecord) {
        LarkMessageTemplateType templateType;
        CreateMessageReqBody.Builder bodyBuilder = CreateMessageReqBody.newBuilder().receiveId(this.sinkConnectorConfig.getReceiveId()).uuid(UUID.randomUUID().toString());
        String templateTypeKey = connectRecord.getExtension("templatetype4lark");
        if (null == templateTypeKey || "null".equals(templateTypeKey)) {
            templateTypeKey = LarkMessageTemplateType.PLAIN_TEXT.getTemplateKey();
        }
        if (LarkMessageTemplateType.PLAIN_TEXT == (templateType = LarkMessageTemplateType.of(templateTypeKey))) {
            bodyBuilder.content(this.createTextContent(connectRecord)).msgType(MsgTypeEnum.MSG_TYPE_TEXT.getValue());
        } else if (LarkMessageTemplateType.MARKDOWN == templateType) {
            String title = Optional.ofNullable(connectRecord.getExtension("markdownmessagetitle4lark")).orElse("EventMesh-Message");
            bodyBuilder.content(this.createInteractiveContent(connectRecord, title)).msgType(MsgTypeEnum.MSG_TYPE_INTERACTIVE.getValue());
        }
        return CreateMessageReq.newBuilder().receiveIdType(this.sinkConnectorConfig.getReceiveIdType()).createMessageReqBody(bodyBuilder.build()).build();
    }

    private String createTextContent(ConnectRecord connectRecord) {
        String atUsers;
        MessageText.Builder msgBuilder = MessageText.newBuilder();
        if (this.needAtAll(connectRecord)) {
            msgBuilder.atAll();
        }
        if (!(atUsers = this.needAtUser(connectRecord)).isEmpty()) {
            String[] users;
            for (String user : users = atUsers.split(";")) {
                String[] kv = user.split(",");
                msgBuilder.atUser(kv[0], kv[1]);
            }
        }
        String escapedString = StringEscapeUtils.escapeJava((String)new String((byte[])connectRecord.getData()));
        return msgBuilder.text(escapedString).build();
    }

    private String createInteractiveContent(ConnectRecord connectRecord, String title) {
        String atUsers;
        StringBuilder sb = new StringBuilder();
        if (this.needAtAll(connectRecord)) {
            this.atAll(sb);
        }
        if (!(atUsers = this.needAtUser(connectRecord)).isEmpty()) {
            String[] users;
            for (String user : users = atUsers.split(";")) {
                String[] kv = user.split(",");
                this.atUser(sb, kv[0]);
            }
        }
        sb.append(new String((byte[])connectRecord.getData()));
        MessageCardConfig config = MessageCardConfig.newBuilder().enableForward(Boolean.valueOf(true)).wideScreenMode(Boolean.valueOf(true)).updateMulti(Boolean.valueOf(true)).build();
        MessageCardHeader header = MessageCardHeader.newBuilder().template(MessageCardHeaderTemplateEnum.BLUE).title(MessageCardPlainText.newBuilder().content(title).build()).build();
        MessageCard content = MessageCard.newBuilder().config(config).header(header).elements(new MessageCardElement[]{MessageCardMarkdown.newBuilder().content(sb.toString()).build()}).build();
        return content.String();
    }

    private boolean needAtAll(ConnectRecord connectRecord) {
        String atAll = connectRecord.getExtension("atall4lark");
        return null != atAll && !"null".equals(atAll) && Boolean.parseBoolean(atAll);
    }

    private String needAtUser(ConnectRecord connectRecord) {
        String atUsers = connectRecord.getExtension("atusers4lark");
        return null != atUsers && !"null".equals(atUsers) ? atUsers : "";
    }

    private void atAll(StringBuilder sb) {
        sb.append("<at id=all>").append("</at>");
    }

    private void atUser(StringBuilder sb, String userId) {
        sb.append("<at id=").append(userId).append(">").append("</at>");
    }
}

