/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.redis.sink.connector;

import io.cloudevents.CloudEvent;
import java.util.List;
import org.apache.eventmesh.connector.redis.cloudevent.CloudEventCodec;
import org.apache.eventmesh.connector.redis.sink.config.RedisSinkConfig;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.util.CloudEventUtil;
import org.redisson.Redisson;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisSinkConnector
implements Sink {
    private static final Logger log = LoggerFactory.getLogger(RedisSinkConnector.class);
    private RTopic topic;
    private RedisSinkConfig sinkConfig;
    private RedissonClient redissonClient;

    public Class<? extends org.apache.eventmesh.openconnect.api.config.Config> configClass() {
        return RedisSinkConfig.class;
    }

    public void init(org.apache.eventmesh.openconnect.api.config.Config config) throws Exception {
        this.sinkConfig = (RedisSinkConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SinkConnectorContext sinkConnectorContext = (SinkConnectorContext)connectorContext;
        this.sinkConfig = (RedisSinkConfig)sinkConnectorContext.getSinkConfig();
        this.doInit();
    }

    private void doInit() {
        Config redisConfig = new Config();
        redisConfig.useSingleServer().setAddress(this.sinkConfig.connectorConfig.getServer());
        redisConfig.setCodec((Codec)CloudEventCodec.getInstance());
        this.redissonClient = Redisson.create((Config)redisConfig);
    }

    public void start() throws Exception {
        this.topic = this.redissonClient.getTopic(this.sinkConfig.connectorConfig.getTopic());
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sinkConfig.getConnectorConfig().getConnectorName();
    }

    public void stop() throws Exception {
        this.redissonClient.shutdown();
    }

    public void put(List<ConnectRecord> sinkRecords) {
        for (ConnectRecord connectRecord : sinkRecords) {
            CloudEvent event = CloudEventUtil.convertRecordToEvent((ConnectRecord)connectRecord);
            try {
                long l = this.topic.publish((Object)event);
            }
            catch (Exception e) {
                log.error("[RedisSinkConnector] sendResult has error : ", (Throwable)e);
            }
        }
    }
}

