/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.wechat.sink.connector;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.connector.wechat.sink.config.WeChatSinkConfig;
import org.apache.eventmesh.connector.wechat.sink.connector.TemplateMessageResponse;
import org.apache.eventmesh.openconnect.api.config.Config;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeChatSinkConnector
implements Sink {
    private static final Logger log = LoggerFactory.getLogger(WeChatSinkConnector.class);
    public static final Cache<String, String> ACCESS_TOKEN_CACHE = CacheBuilder.newBuilder().initialCapacity(12).maximumSize(10L).concurrencyLevel(5).expireAfterWrite(120L, TimeUnit.MINUTES).build();
    public static final String ACCESS_TOKEN_CACHE_KEY = "access_token";
    private static final String ACCESS_TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";
    private static final String MESSAGE_SEND_URL = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=%s";
    private OkHttpClient okHttpClient;
    private WeChatSinkConfig sinkConfig;
    private volatile boolean isRunning = false;

    public Class<? extends Config> configClass() {
        return WeChatSinkConfig.class;
    }

    public void init(Config config) {
        this.sinkConfig = (WeChatSinkConfig)config;
        this.okHttpClient = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).retryOnConnectionFailure(true).build();
    }

    public void init(ConnectorContext connectorContext) {
        SinkConnectorContext sinkConnectorContext = (SinkConnectorContext)connectorContext;
        this.sinkConfig = (WeChatSinkConfig)sinkConnectorContext.getSinkConfig();
        this.okHttpClient = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).retryOnConnectionFailure(true).build();
    }

    public void start() {
        this.isRunning = true;
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sinkConfig.getSinkConnectorConfig().getConnectorName();
    }

    public void stop() throws IOException {
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void put(List<ConnectRecord> sinkRecords) {
        for (ConnectRecord record : sinkRecords) {
            try {
                if (Objects.isNull(record.getData())) {
                    log.warn("ConnectRecord data is null, ignore.");
                    continue;
                }
                this.sendMessage(record);
            }
            catch (Exception e) {
                log.error("Failed to sink message to WeChat.", (Throwable)e);
            }
        }
    }

    private void sendMessage(ConnectRecord record) {
        String accessToken = this.getAccessToken();
        MediaType mediaType = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)new String((byte[])record.getData()));
        Request request = new Request.Builder().url(String.format(MESSAGE_SEND_URL, accessToken)).post(body).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                log.error("server response: {}", (Object)ToStringBuilder.reflectionToString((Object)response));
                throw new IOException("Unexpected code " + response);
            }
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                throw new IOException("Response body is null.");
            }
            String jsonStr = responseBody.string();
            TemplateMessageResponse messageResponse = (TemplateMessageResponse)JsonUtils.parseObject((String)jsonStr, TemplateMessageResponse.class);
            if (messageResponse == null) {
                throw new IOException("message response is null.");
            }
            if (messageResponse.getErrcode() != 0) {
                throw new IllegalAccessException(String.format("Send message to WeChat error! errorCode=%s, errorMessage=%s", messageResponse.getErrcode(), messageResponse.getErrmsg()));
            }
        }
    }

    private String getAccessToken() {
        return (String)ACCESS_TOKEN_CACHE.get((Object)ACCESS_TOKEN_CACHE_KEY, () -> {
            String accessToken;
            Request tokenRequest = new Request.Builder().url(String.format(ACCESS_TOKEN_URL, this.sinkConfig.getSinkConnectorConfig().getAppId(), this.sinkConfig.getSinkConnectorConfig().getAppSecret())).get().build();
            try (Response response = this.okHttpClient.newCall(tokenRequest).execute();){
                if (!response.isSuccessful()) {
                    log.error("server response: {}", (Object)ToStringBuilder.reflectionToString((Object)response));
                    throw new IOException("Unexpected code " + response);
                }
                String json = Objects.requireNonNull(response.body()).string();
                JSONObject jsonObject = JSON.parseObject((String)json);
                accessToken = Objects.requireNonNull(jsonObject).getString(ACCESS_TOKEN_CACHE_KEY);
                ACCESS_TOKEN_CACHE.put((Object)ACCESS_TOKEN_CACHE_KEY, (Object)accessToken);
            }
            return accessToken;
        });
    }
}

