/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.metrics.prometheus.metrics;

import com.google.common.collect.ImmutableMap;
import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.api.metrics.Meter;
import java.util.Map;
import java.util.function.Function;
import org.apache.eventmesh.metrics.api.model.HttpSummaryMetrics;
import org.apache.eventmesh.metrics.api.model.Metric;
import org.apache.eventmesh.metrics.prometheus.utils.PrometheusExporterUtils;

public final class PrometheusHttpExporter {
    private static final Map<String[], Function<HttpSummaryMetrics, Number>> paramPairs = ImmutableMap.builder().put((Object)PrometheusExporterUtils.join("eventmesh.http.request.tps.max", "max TPS of HTTP."), HttpSummaryMetrics::maxHTTPTPS).put((Object)PrometheusExporterUtils.join("eventmesh.http.request.tps.avg", "avg TPS of HTTP."), HttpSummaryMetrics::avgHTTPTPS).put((Object)PrometheusExporterUtils.join("eventmesh.http.request.cost.max", "max cost of HTTP."), HttpSummaryMetrics::maxHTTPCost).put((Object)PrometheusExporterUtils.join("eventmesh.http.request.cost.avg", "avg cost of HTTP."), HttpSummaryMetrics::avgHTTPCost).put((Object)PrometheusExporterUtils.join("eventmesh.http.body.decode.cost.avg", "avg body decode cost of HTTP."), HttpSummaryMetrics::avgHTTPBodyDecodeCost).put((Object)PrometheusExporterUtils.join("eventmesh.http.request.discard.num", "http request discard num."), HttpSummaryMetrics::getHttpDiscard).put((Object)PrometheusExporterUtils.join("eventmesh.batch.send.message.tps.max", "max of batch send message tps."), HttpSummaryMetrics::maxSendBatchMsgTPS).put((Object)PrometheusExporterUtils.join("eventmesh.batch.send.message.tps.avg", "avg of batch send message tps."), HttpSummaryMetrics::avgSendBatchMsgTPS).put((Object)PrometheusExporterUtils.join("eventmesh.batch.send.message.num", "sum of batch send message number."), HttpSummaryMetrics::getSendBatchMsgNumSum).put((Object)PrometheusExporterUtils.join("eventmesh.batch.send.message.fail.num", "sum of batch send message fail message number."), HttpSummaryMetrics::getSendBatchMsgFailNumSum).put((Object)PrometheusExporterUtils.join("eventmesh.batch.send.message.fail.rate", "send batch message fail rate."), HttpSummaryMetrics::getSendBatchMsgFailRate).put((Object)PrometheusExporterUtils.join("eventmesh.batch.send.message.discard.num", "sum of send batch message discard number."), HttpSummaryMetrics::getSendBatchMsgDiscardNumSum).put((Object)PrometheusExporterUtils.join("eventmesh.send.message.tps.max", "max of send message tps."), HttpSummaryMetrics::maxSendMsgTPS).put((Object)PrometheusExporterUtils.join("eventmesh.send.message.tps.avg", "avg of send message tps."), HttpSummaryMetrics::avgSendMsgTPS).put((Object)PrometheusExporterUtils.join("eventmesh.send.message.num", "sum of send message number."), HttpSummaryMetrics::getSendMsgNumSum).put((Object)PrometheusExporterUtils.join("eventmesh.send.message.fail.num", "sum of send message fail number."), HttpSummaryMetrics::getSendMsgFailNumSum).put((Object)PrometheusExporterUtils.join("eventmesh.send.message.fail.rate", "send message fail rate."), HttpSummaryMetrics::getSendMsgFailRate).put((Object)PrometheusExporterUtils.join("eventmesh.reply.message.num", "sum of reply message number."), HttpSummaryMetrics::getReplyMsgNumSum).put((Object)PrometheusExporterUtils.join("eventmesh.reply.message.fail.num", "sum of reply message fail number."), HttpSummaryMetrics::getReplyMsgFailNumSum).put((Object)PrometheusExporterUtils.join("eventmesh.push.message.tps.max", "max of push message tps."), HttpSummaryMetrics::maxPushMsgTPS).put((Object)PrometheusExporterUtils.join("eventmesh.push.message.tps.avg", "avg of push message tps."), HttpSummaryMetrics::avgPushMsgTPS).put((Object)PrometheusExporterUtils.join("eventmesh.http.push.message.num", "sum of http push message number."), HttpSummaryMetrics::getHttpPushMsgNumSum).put((Object)PrometheusExporterUtils.join("eventmesh.http.push.message.fail.num", "sum of http push message fail number."), HttpSummaryMetrics::getHttpPushFailNumSum).put((Object)PrometheusExporterUtils.join("eventmesh.http.push.message.fail.rate", "http push message fail rate."), HttpSummaryMetrics::getHttpPushMsgFailRate).put((Object)PrometheusExporterUtils.join("eventmesh.http.push.latency.max", "max of http push latency."), HttpSummaryMetrics::maxHTTPPushLatency).put((Object)PrometheusExporterUtils.join("eventmesh.http.push.latency.avg", "avg of http push latency."), HttpSummaryMetrics::avgHTTPPushLatency).put((Object)PrometheusExporterUtils.join("eventmesh.batch.message.queue.size", "size of batch message queue."), HttpSummaryMetrics::getBatchMsgQueueSize).put((Object)PrometheusExporterUtils.join("eventmesh.send.message.queue.size", "size of send message queue."), HttpSummaryMetrics::getSendMsgQueueSize).put((Object)PrometheusExporterUtils.join("eventmesh.push.message.queue.size", "size of push message queue."), HttpSummaryMetrics::getPushMsgQueueSize).put((Object)PrometheusExporterUtils.join("eventmesh.http.retry.queue.size", "size of http retry queue."), HttpSummaryMetrics::getHttpRetryQueueSize).put((Object)PrometheusExporterUtils.join("eventmesh.batch.send.message.cost.avg", "avg of batch send message cost."), HttpSummaryMetrics::avgBatchSendMsgCost).put((Object)PrometheusExporterUtils.join("eventmesh.send.message.cost.avg", "avg of send message cost."), HttpSummaryMetrics::avgSendMsgCost).put((Object)PrometheusExporterUtils.join("eventmesh.reply.message.cost.avg", "avg of reply message cost."), HttpSummaryMetrics::avgReplyMsgCost).build();

    public static void export(String name, HttpSummaryMetrics summaryMetrics) {
        Meter meter = GlobalMeterProvider.getMeter((String)name);
        paramPairs.forEach((metricInfo, getMetric) -> PrometheusExporterUtils.observeOfValue(meter, metricInfo[0], metricInfo[1], "HTTP", (Metric)summaryMetrics, getMetric, HttpSummaryMetrics.class));
    }

    private PrometheusHttpExporter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

