/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.metrics.prometheus.metrics;

import com.google.common.collect.ImmutableMap;
import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.api.metrics.Meter;
import java.util.Map;
import java.util.function.Function;
import org.apache.eventmesh.metrics.api.model.Metric;
import org.apache.eventmesh.metrics.api.model.TcpSummaryMetrics;
import org.apache.eventmesh.metrics.prometheus.utils.PrometheusExporterUtils;

public final class PrometheusTcpExporter {
    private static final Map<String[], Function<TcpSummaryMetrics, Number>> paramPairs = ImmutableMap.builder().put((Object)PrometheusExporterUtils.join("retry.queue.size", "get size of retry queue."), TcpSummaryMetrics::getRetrySize).put((Object)PrometheusExporterUtils.join("server.tps", "get tps of client to eventMesh."), TcpSummaryMetrics::getClient2eventMeshTPS).put((Object)PrometheusExporterUtils.join("mq.provider.tps", "get tps of eventMesh to mq."), TcpSummaryMetrics::getEventMesh2mqTPS).put((Object)PrometheusExporterUtils.join("mq.consumer.tps", "get tps of mq to eventMesh."), TcpSummaryMetrics::getMq2eventMeshTPS).put((Object)PrometheusExporterUtils.join("client.tps", "get tps of eventMesh to client."), TcpSummaryMetrics::getEventMesh2clientTPS).put((Object)PrometheusExporterUtils.join("all.tps", "get all TPS."), TcpSummaryMetrics::getAllTPS).put((Object)PrometheusExporterUtils.join("connection.num", "EventMeshTcpConnectionHandler.connections."), TcpSummaryMetrics::getAllConnections).put((Object)PrometheusExporterUtils.join("sub.topic.num", "get sub topic num."), TcpSummaryMetrics::getSubTopicNum).build();

    public static void export(String meterName, TcpSummaryMetrics summaryMetrics) {
        Meter meter = GlobalMeterProvider.getMeter((String)meterName);
        paramPairs.forEach((metricInfo, getMetric) -> PrometheusExporterUtils.observeOfValue(meter, "eventmesh.tcp." + metricInfo[0], metricInfo[1], "TCP", (Metric)summaryMetrics, getMetric, TcpSummaryMetrics.class));
    }

    private PrometheusTcpExporter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

