/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.tcp;

import com.google.common.base.Preconditions;
import io.cloudevents.CloudEvent;
import io.openmessaging.api.Message;
import org.apache.eventmesh.client.tcp.EventMeshTCPClient;
import org.apache.eventmesh.client.tcp.conf.EventMeshTCPClientConfig;
import org.apache.eventmesh.client.tcp.impl.cloudevent.CloudEventTCPClient;
import org.apache.eventmesh.client.tcp.impl.eventmeshmessage.EventMeshMessageTCPClient;
import org.apache.eventmesh.client.tcp.impl.openmessage.OpenMessageTCPClient;
import org.apache.eventmesh.common.protocol.tcp.EventMeshMessage;

public final class EventMeshTCPClientFactory {
    public static <ProtocolMessage> EventMeshTCPClient<ProtocolMessage> createEventMeshTCPClient(EventMeshTCPClientConfig eventMeshTcpClientConfig, Class<ProtocolMessage> protocolMessageClass) {
        Preconditions.checkNotNull(protocolMessageClass, (Object)"ProtocolMessage type cannot be null");
        Preconditions.checkNotNull((Object)eventMeshTcpClientConfig, (Object)"EventMeshTcpClientConfig cannot be null");
        if (protocolMessageClass.isAssignableFrom(EventMeshMessage.class)) {
            return new EventMeshMessageTCPClient(eventMeshTcpClientConfig);
        }
        if (protocolMessageClass.isAssignableFrom(CloudEvent.class)) {
            return new CloudEventTCPClient(eventMeshTcpClientConfig);
        }
        if (protocolMessageClass.isAssignableFrom(Message.class)) {
            return new OpenMessageTCPClient(eventMeshTcpClientConfig);
        }
        throw new IllegalArgumentException(String.format("ProtocolMessageClass: %s is not supported", protocolMessageClass));
    }

    private EventMeshTCPClientFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

