/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.openconnect.offsetmgmt.api.data;

import java.util.Objects;
import java.util.Set;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.DefaultKeyValue;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.KeyValue;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.RecordOffset;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.RecordPartition;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.RecordPosition;

public class ConnectRecord {
    private Long timestamp;
    private Object data;
    private RecordPosition position;
    private KeyValue extensions;

    public ConnectRecord(RecordPartition recordPartition, RecordOffset recordOffset, Long timestamp) {
        this(recordPartition, recordOffset, timestamp, null);
    }

    public ConnectRecord(RecordPartition recordPartition, RecordOffset recordOffset, Long timestamp, Object data) {
        this.position = new RecordPosition(recordPartition, recordOffset);
        this.timestamp = timestamp;
        this.data = data;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public KeyValue getExtensions() {
        return this.extensions;
    }

    public void setExtensions(KeyValue extensions) {
        this.extensions = extensions;
    }

    public RecordPosition getPosition() {
        return this.position;
    }

    public void setPosition(RecordPosition position) {
        this.position = position;
    }

    public void addExtension(KeyValue extensions) {
        if (this.extensions == null) {
            this.extensions = new DefaultKeyValue();
        }
        Set<String> keySet = extensions.keySet();
        for (String key : keySet) {
            this.extensions.put(key, extensions.getObject(key));
        }
    }

    public void addExtension(String key, Object value) {
        if (this.extensions == null) {
            this.extensions = new DefaultKeyValue();
        }
        this.extensions.put(key, value);
    }

    public String getExtension(String key) {
        if (this.extensions == null || !this.extensions.containsKey(key)) {
            return null;
        }
        return this.extensions.getString(key);
    }

    public <T> T getExtension(String key, Class<T> c) {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.getObject(key, c);
    }

    public Object getExtensionObj(String key) {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.getObject(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectRecord)) {
            return false;
        }
        ConnectRecord that = (ConnectRecord)o;
        return Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.data, that.data) && Objects.equals(this.position, that.position) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.data, this.position, this.extensions);
    }

    public String toString() {
        return "ConnectRecord{timestamp=" + this.timestamp + ", data=" + this.data + ", position=" + this.position + ", extensions=" + this.extensions + "}";
    }
}

