/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.core.response;

import com.lark.oapi.core.utils.FileNameParser;
import com.lark.oapi.core.utils.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RawResponse {
    private int statusCode;
    private String contentType;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private byte[] body;

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        ArrayList<String> ct = new ArrayList<String>();
        ct.add(contentType);
        this.headers.put("Content-Type", ct);
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    private String getHeaderFirstValue(String name) {
        List<String> values = this.headers.get(name);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return "";
    }

    public String getRequestID() {
        String logID = this.getHeaderFirstValue("X-Tt-Logid");
        if (!Strings.isEmpty(logID)) {
            return logID;
        }
        return this.getHeaderFirstValue("X-Request-Id");
    }

    public String getFileName() {
        String contentDisposition = this.getHeaderFirstValue("Content-Disposition");
        return FileNameParser.parseFileName(contentDisposition);
    }
}

