/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.mongodb.sink.connector;

import com.mongodb.connection.ClusterType;
import io.cloudevents.CloudEvent;
import java.util.List;
import org.apache.eventmesh.connector.mongodb.sink.client.Impl.MongodbSinkClient;
import org.apache.eventmesh.connector.mongodb.sink.client.MongodbReplicaSetSinkClient;
import org.apache.eventmesh.connector.mongodb.sink.client.MongodbStandaloneSinkClient;
import org.apache.eventmesh.connector.mongodb.sink.config.MongodbSinkConfig;
import org.apache.eventmesh.openconnect.api.config.Config;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.util.CloudEventUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodbSinkConnector
implements Sink {
    private static final Logger log = LoggerFactory.getLogger(MongodbSinkConnector.class);
    private MongodbSinkConfig sinkConfig;
    private MongodbSinkClient client;

    public Class<? extends Config> configClass() {
        return MongodbSinkConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sinkConfig = (MongodbSinkConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SinkConnectorContext sinkConnectorContext = (SinkConnectorContext)connectorContext;
        this.sinkConfig = (MongodbSinkConfig)sinkConnectorContext.getSinkConfig();
        this.doInit();
    }

    private void doInit() {
        String connectorType = this.sinkConfig.getConnectorConfig().getConnectorType();
        if (connectorType.equals(ClusterType.STANDALONE.name())) {
            this.client = new MongodbStandaloneSinkClient(this.sinkConfig.getConnectorConfig());
        }
        if (connectorType.equals(ClusterType.REPLICA_SET.name())) {
            this.client = new MongodbReplicaSetSinkClient(this.sinkConfig.getConnectorConfig());
        }
        this.client.init();
    }

    public void start() throws Exception {
        this.client.start();
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sinkConfig.getConnectorConfig().getConnectorName();
    }

    public void stop() throws Exception {
        this.client.stop();
    }

    public void put(List<ConnectRecord> sinkRecords) {
        try {
            for (ConnectRecord connectRecord : sinkRecords) {
                CloudEvent event = CloudEventUtil.convertRecordToEvent((ConnectRecord)connectRecord);
                this.client.publish(event);
                log.debug("Produced message to event:{}}", (Object)event);
            }
        }
        catch (Exception e) {
            log.error("Failed to produce message:{}", (Object)e.getMessage());
        }
    }
}

