/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.mongodb.source.client;

import com.mongodb.ConnectionString;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.cloudevents.CloudEvent;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.connector.mongodb.source.client.Impl.MongodbSourceClient;
import org.apache.eventmesh.connector.mongodb.source.config.SourceConnectorConfig;
import org.apache.eventmesh.connector.mongodb.utils.MongodbCloudEventUtil;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodbStandaloneSourceClient
implements MongodbSourceClient {
    private static final Logger log = LoggerFactory.getLogger(MongodbStandaloneSourceClient.class);
    private final SourceConnectorConfig connectorConfig;
    private volatile boolean started = false;
    private MongoClient client;
    private MongoCollection<Document> cappedCol;
    private final BlockingQueue<CloudEvent> queue;
    private final SubTask task = new SubTask();
    private final ThreadPoolExecutor executor = ThreadPoolFactory.createThreadPoolExecutor((int)(Runtime.getRuntime().availableProcessors() * 2), (int)(Runtime.getRuntime().availableProcessors() * 2), (String)"EventMesh-MongodbStandaloneSourceClient-");

    public MongodbStandaloneSourceClient(SourceConnectorConfig connectorConfig, BlockingQueue<CloudEvent> queue) {
        this.queue = queue;
        this.connectorConfig = connectorConfig;
    }

    @Override
    public void init() {
        this.client = MongoClients.create((ConnectionString)new ConnectionString(this.connectorConfig.getUrl()));
        MongoDatabase db = this.client.getDatabase(this.connectorConfig.getDatabase());
        this.cappedCol = db.getCollection(this.connectorConfig.getCollection());
        Document index = new Document("ts", (Object)1).append("topic", (Object)1);
        this.cappedCol.createIndex((Bson)index);
    }

    @Override
    public void start() {
        if (!this.started) {
            this.executor.execute(this.task);
            this.started = true;
        }
    }

    @Override
    public void stop() {
        if (this.started) {
            try {
                this.task.stop();
                this.client.close();
            }
            finally {
                this.started = false;
            }
        }
    }

    private FindIterable<Document> getCursor(MongoCollection<Document> collection, String topic, int lastId) {
        Document index = new Document("$gt", (Object)lastId);
        Document ts = new Document("ts", (Object)index);
        Document spec = ts.append("topic", (Object)topic);
        return collection.find((Bson)spec);
    }

    private class SubTask
    implements Runnable {
        private final AtomicBoolean stop = new AtomicBoolean(false);

        private SubTask() {
        }

        @Override
        public void run() {
            int lastId = -1;
            while (!this.stop.get()) {
                try {
                    FindIterable cur = MongodbStandaloneSourceClient.this.getCursor((MongoCollection<Document>)MongodbStandaloneSourceClient.this.cappedCol, "flag", lastId);
                    for (Document obj : cur) {
                        CloudEvent cloudEvent = MongodbCloudEventUtil.convertToCloudEvent(obj);
                        MongodbStandaloneSourceClient.this.queue.add(cloudEvent);
                        try {
                            lastId = (int)((Double)obj.get((Object)"ts")).doubleValue();
                        }
                        catch (ClassCastException ce) {
                            lastId = (Integer)obj.get((Object)"ts");
                        }
                    }
                }
                catch (Exception ex) {
                    log.error("[MongodbStandaloneSourceClient] thread run happen exception.", (Throwable)ex);
                }
                Thread.yield();
            }
        }

        public void stop() {
            this.stop.set(true);
        }
    }
}

