/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.protocol.http.header.client;

import java.util.Map;
import org.apache.eventmesh.common.protocol.http.common.ProtocolKey;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.utils.HttpConvertsUtils;

public class HeartbeatResponseHeader
extends Header {
    private int code;
    private String eventMeshCluster;
    private String eventMeshIp;
    private String eventMeshEnv;
    private String eventMeshIdc;

    public static HeartbeatResponseHeader buildHeader(Integer requestCode, String eventMeshCluster, String eventMeshIp, String eventMeshEnv, String eventMeshIDC) {
        HeartbeatResponseHeader heartbeatResponseHeader = new HeartbeatResponseHeader();
        heartbeatResponseHeader.setCode(requestCode);
        heartbeatResponseHeader.setEventMeshCluster(eventMeshCluster);
        heartbeatResponseHeader.setEventMeshIp(eventMeshIp);
        heartbeatResponseHeader.setEventMeshEnv(eventMeshEnv);
        heartbeatResponseHeader.setEventMeshIdc(eventMeshIDC);
        return heartbeatResponseHeader;
    }

    @Override
    public Map<String, Object> toMap() {
        HttpConvertsUtils httpConvertsUtils = new HttpConvertsUtils();
        ProtocolKey protocolKey = new ProtocolKey();
        ProtocolKey.EventMeshInstanceKey eventMeshInstanceKey = new ProtocolKey.EventMeshInstanceKey();
        return httpConvertsUtils.httpMapConverts(this, protocolKey, eventMeshInstanceKey);
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setEventMeshCluster(String eventMeshCluster) {
        this.eventMeshCluster = eventMeshCluster;
    }

    public void setEventMeshIp(String eventMeshIp) {
        this.eventMeshIp = eventMeshIp;
    }

    public void setEventMeshEnv(String eventMeshEnv) {
        this.eventMeshEnv = eventMeshEnv;
    }

    public void setEventMeshIdc(String eventMeshIdc) {
        this.eventMeshIdc = eventMeshIdc;
    }

    public int getCode() {
        return this.code;
    }

    public String getEventMeshCluster() {
        return this.eventMeshCluster;
    }

    public String getEventMeshIp() {
        return this.eventMeshIp;
    }

    public String getEventMeshEnv() {
        return this.eventMeshEnv;
    }

    public String getEventMeshIdc() {
        return this.eventMeshIdc;
    }

    public String toString() {
        return "HeartbeatResponseHeader(code=" + this.getCode() + ", eventMeshCluster=" + this.getEventMeshCluster() + ", eventMeshIp=" + this.getEventMeshIp() + ", eventMeshEnv=" + this.getEventMeshEnv() + ", eventMeshIdc=" + this.getEventMeshIdc() + ")";
    }
}

