/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.pravega.source.connector;

import io.cloudevents.CloudEvent;
import io.pravega.client.ClientConfig;
import io.pravega.client.EventStreamClientFactory;
import io.pravega.client.admin.ReaderGroupManager;
import io.pravega.client.admin.StreamManager;
import io.pravega.client.stream.EventRead;
import io.pravega.client.stream.EventStreamReader;
import io.pravega.client.stream.ReaderConfig;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.client.stream.Serializer;
import io.pravega.client.stream.impl.ByteArraySerializer;
import io.pravega.shared.NameUtils;
import io.pravega.shared.security.auth.Credentials;
import io.pravega.shared.security.auth.DefaultCredentials;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.connector.pravega.client.PravegaEvent;
import org.apache.eventmesh.connector.pravega.source.config.PravegaSourceConfig;
import org.apache.eventmesh.openconnect.api.config.Config;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.util.CloudEventUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PravegaSourceConnector
implements Source {
    private static final Logger log = LoggerFactory.getLogger(PravegaSourceConnector.class);
    private static final AtomicBoolean started = new AtomicBoolean(false);
    private static final int DEFAULT_BATCH_SIZE = 10;
    private PravegaSourceConfig sourceConfig;
    private StreamManager streamManager;
    private EventStreamClientFactory clientFactory;
    private ReaderGroupManager readerGroupManager;
    private final Map<String, PravegaSourceHandler> sourceHandlerMap = new ConcurrentHashMap<String, PravegaSourceHandler>();
    private BlockingQueue<CloudEvent> queue;
    private final ThreadPoolExecutor executor = ThreadPoolFactory.createThreadPoolExecutor((int)(Runtime.getRuntime().availableProcessors() * 2), (int)(Runtime.getRuntime().availableProcessors() * 2), (String)"EventMesh-RabbitMQSourceConnector-");

    public Class<? extends Config> configClass() {
        return PravegaSourceConfig.class;
    }

    public void init(Config config) throws Exception {
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        this.sourceConfig = (PravegaSourceConfig)sourceConnectorContext.getSourceConfig();
        this.queue = new LinkedBlockingQueue<CloudEvent>(1000);
        this.streamManager = StreamManager.create((URI)this.sourceConfig.getConnectorConfig().getControllerURI());
        ClientConfig.ClientConfigBuilder clientConfigBuilder = ClientConfig.builder().controllerURI(this.sourceConfig.getConnectorConfig().getControllerURI());
        if (this.sourceConfig.getConnectorConfig().isAuthEnabled()) {
            clientConfigBuilder.credentials((Credentials)new DefaultCredentials(this.sourceConfig.getConnectorConfig().getPassword(), this.sourceConfig.getConnectorConfig().getUsername()));
        }
        if (this.sourceConfig.getConnectorConfig().isTlsEnable()) {
            clientConfigBuilder.trustStore(this.sourceConfig.getConnectorConfig().getTruststore()).validateHostName(false);
        }
        ClientConfig clientConfig = clientConfigBuilder.build();
        this.clientFactory = EventStreamClientFactory.withScope((String)this.sourceConfig.getConnectorConfig().getScope(), (ClientConfig)clientConfig);
        this.readerGroupManager = ReaderGroupManager.withScope((String)this.sourceConfig.getConnectorConfig().getScope(), (ClientConfig)clientConfig);
        this.initReaders();
    }

    private void initReaders() {
        this.streamManager.listStreams(this.sourceConfig.getConnectorConfig().getScope()).forEachRemaining(stream -> {
            if (stream.getStreamName().startsWith("_")) {
                return;
            }
            ReaderGroupConfig readerGroupConfig = ReaderGroupConfig.builder().stream(NameUtils.getScopedStreamName((String)this.sourceConfig.getConnectorConfig().getScope(), (String)stream.getStreamName())).retentionType(ReaderGroupConfig.StreamDataRetention.AUTOMATIC_RELEASE_AT_LAST_CHECKPOINT).build();
            this.readerGroupManager.createReaderGroup(stream.getStreamName(), readerGroupConfig);
            EventStreamReader reader = this.clientFactory.createReader("PravegaSourceConnector-reader", stream.getStreamName(), (Serializer)new ByteArraySerializer(), ReaderConfig.builder().build());
            this.sourceHandlerMap.put(stream.getStreamName(), new PravegaSourceHandler((EventStreamReader<byte[]>)reader));
        });
    }

    public void start() throws Exception {
        this.sourceHandlerMap.forEach((topic, handler) -> this.executor.execute((Runnable)handler));
        started.compareAndSet(false, true);
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sourceConfig.getConnectorConfig().getConnectorName();
    }

    public void stop() {
        this.sourceHandlerMap.forEach((topic, handler) -> {
            this.readerGroupManager.deleteReaderGroup(topic);
            handler.stop();
        });
        this.sourceHandlerMap.clear();
        this.readerGroupManager.close();
        this.clientFactory.close();
        this.streamManager.close();
        started.compareAndSet(true, false);
    }

    public List<ConnectRecord> poll() {
        ArrayList<ConnectRecord> connectRecords = new ArrayList<ConnectRecord>(10);
        for (int count = 0; count < 10; ++count) {
            try {
                CloudEvent event = this.queue.poll(3L, TimeUnit.SECONDS);
                if (event == null) break;
                connectRecords.add(CloudEventUtil.convertEventToRecord((CloudEvent)event));
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return connectRecords;
    }

    public class PravegaSourceHandler
    implements Runnable {
        private final EventStreamReader<byte[]> reader;
        private final AtomicBoolean running = new AtomicBoolean(true);

        public PravegaSourceHandler(EventStreamReader<byte[]> reader) {
            this.reader = reader;
        }

        @Override
        public void run() {
            while (this.running.get()) {
                try {
                    EventRead event = this.reader.readNextEvent(2000L);
                    byte[] eventByteArray = (byte[])event.getEvent();
                    if (eventByteArray == null) continue;
                    PravegaEvent pravegaEvent = PravegaEvent.getFromByteArray(eventByteArray);
                    CloudEvent cloudEvent = pravegaEvent.convertToCloudEvent();
                    PravegaSourceConnector.this.queue.add(cloudEvent);
                }
                catch (Exception ex) {
                    log.error("[PravegaSourceHandler] thread run happen exception.", (Throwable)ex);
                }
            }
        }

        public void stop() {
            this.running.compareAndSet(true, false);
        }
    }
}

