/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import org.redisson.api.RedissonClient;
import org.redisson.api.annotation.RInject;

public class Injector {
    public static <T> void inject(Object task, Class<T> valueClass, T value) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        Class<?> clazz = task.getClass();
        while (clazz != null) {
            Field[] fields = clazz.getDeclaredFields();
            allFields.addAll(Arrays.asList(fields));
            if (clazz.getSuperclass() != Object.class) {
                clazz = clazz.getSuperclass();
                continue;
            }
            clazz = null;
        }
        for (Field field : allFields) {
            if (!valueClass.isAssignableFrom(field.getType()) || !field.isAnnotationPresent(RInject.class)) continue;
            field.setAccessible(true);
            try {
                field.set(task, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static void inject(Object task, RedissonClient redisson) {
        Injector.inject(task, RedissonClient.class, redisson);
    }
}

