/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.http.source.connector;

import io.cloudevents.CloudEvent;
import io.cloudevents.http.vertx.VertxMessageFactory;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.LoggerHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.connector.http.source.config.HttpSourceConfig;
import org.apache.eventmesh.openconnect.api.config.Config;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.util.CloudEventUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSourceConnector
implements Source {
    private static final Logger log = LoggerFactory.getLogger(HttpSourceConnector.class);
    private static final int DEFAULT_BATCH_SIZE = 10;
    private HttpSourceConfig sourceConfig;
    private BlockingQueue<CloudEvent> queue;
    private HttpServer server;

    public Class<? extends Config> configClass() {
        return HttpSourceConfig.class;
    }

    public void init(Config config) {
        this.sourceConfig = (HttpSourceConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        this.sourceConfig = (HttpSourceConfig)sourceConnectorContext.getSourceConfig();
        this.doInit();
    }

    private void doInit() {
        this.queue = new LinkedBlockingQueue<CloudEvent>(1000);
        Vertx vertx = Vertx.vertx();
        Router router = Router.router((Vertx)vertx);
        router.route().path(this.sourceConfig.connectorConfig.getPath()).method(HttpMethod.POST).handler((Handler)LoggerHandler.create()).handler(ctx -> VertxMessageFactory.createReader((HttpServerRequest)ctx.request()).map(reader -> {
            CloudEvent event = reader.toEvent();
            if (event.getSubject() == null) {
                throw new IllegalStateException("attribute 'subject' cannot be null");
            }
            if (event.getDataContentType() == null) {
                throw new IllegalStateException("attribute 'datacontenttype' cannot be null");
            }
            if (event.getData() == null) {
                throw new IllegalStateException("attribute 'data' cannot be null");
            }
            return event;
        }).onSuccess(event -> {
            this.queue.add((CloudEvent)event);
            log.info("[HttpSourceConnector] Succeed to convert payload into CloudEvent. StatusCode={}", (Object)HttpResponseStatus.OK.code());
            ctx.response().setStatusCode(HttpResponseStatus.OK.code()).end();
        }).onFailure(t -> {
            log.error("[HttpSourceConnector] Malformed request. StatusCode={}", (Object)HttpResponseStatus.BAD_REQUEST.code(), t);
            ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end();
        }));
        this.server = vertx.createHttpServer(new HttpServerOptions().setPort(this.sourceConfig.connectorConfig.getPort()).setIdleTimeout(this.sourceConfig.connectorConfig.getIdleTimeout())).requestHandler((Handler)router);
    }

    public void start() {
        Throwable t = this.server.listen().cause();
        if (t != null) {
            throw new EventMeshException("failed to start Vertx server", t);
        }
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sourceConfig.getConnectorConfig().getConnectorName();
    }

    public void stop() {
        Throwable t = this.server.close().cause();
        if (t != null) {
            throw new EventMeshException("failed to stop Vertx server", t);
        }
    }

    public List<ConnectRecord> poll() {
        ArrayList<ConnectRecord> connectRecords = new ArrayList<ConnectRecord>(10);
        for (int i = 0; i < 10; ++i) {
            try {
                CloudEvent event = this.queue.poll(3L, TimeUnit.SECONDS);
                if (event == null) break;
                connectRecords.add(CloudEventUtil.convertEventToRecord((CloudEvent)event));
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return connectRecords;
    }
}

