/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap;

import java.util.Objects;

public enum AgentType {
    DEFAULT_AGENT("com.navercorp.pinpoint.profiler.DefaultAgent"),
    PLUGIN_TEST("com.navercorp.pinpoint.test.PluginTestAgent");

    private final String className;

    private AgentType(String className) {
        this.className = Objects.requireNonNull(className, "className");
    }

    public String getClassName() {
        return this.className;
    }

    public static AgentType getAgentType(String agentTypeName) {
        if (agentTypeName == null) {
            return DEFAULT_AGENT;
        }
        for (AgentType agentType : AgentType.values()) {
            if (!agentType.name().equalsIgnoreCase(agentTypeName)) continue;
            return agentType;
        }
        throw new IllegalArgumentException("Unknown AgentType:" + agentTypeName);
    }
}

