/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request;

import com.navercorp.pinpoint.bootstrap.context.Header;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.BypassServerCookieRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.BypassServerHeaderRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ServerCookieRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.ServerHeaderRecorder;
import com.navercorp.pinpoint.bootstrap.util.NumberUtils;
import com.navercorp.pinpoint.common.trace.ServiceType;
import java.util.Objects;

public class ServerRequestRecorder<T> {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final RequestAdaptor<T> requestAdaptor;
    private final ServerHeaderRecorder<T> headerRecorder;
    private final ServerCookieRecorder<T> cookieRecorder;

    public ServerRequestRecorder(RequestAdaptor<T> requestAdaptor) {
        this(requestAdaptor, new BypassServerHeaderRecorder(), new BypassServerCookieRecorder());
    }

    public ServerRequestRecorder(RequestAdaptor<T> requestAdaptor, ServerHeaderRecorder<T> headerRecorder, ServerCookieRecorder<T> cookieRecorder) {
        this.requestAdaptor = Objects.requireNonNull(requestAdaptor, "requestAdaptor");
        this.headerRecorder = Objects.requireNonNull(headerRecorder, "headerRecorder");
        this.cookieRecorder = Objects.requireNonNull(cookieRecorder, "cookieRecorder");
    }

    public void record(SpanRecorder recorder, T request) {
        if (recorder == null || request == null) {
            return;
        }
        String rpcName = this.requestAdaptor.getRpcName(request);
        recorder.recordRpcName(rpcName);
        if (this.isDebug) {
            this.logger.debug("Record rpcName={}", (Object)rpcName);
        }
        String endPoint = this.requestAdaptor.getEndPoint(request);
        recorder.recordEndPoint(endPoint);
        if (this.isDebug) {
            this.logger.debug("Record endPoint={}", (Object)endPoint);
        }
        String remoteAddress = this.requestAdaptor.getRemoteAddress(request);
        recorder.recordRemoteAddress(remoteAddress);
        if (this.isDebug) {
            this.logger.debug("Record remoteAddress={}", (Object)remoteAddress);
        }
        this.headerRecorder.recordHeader(recorder, request);
        this.cookieRecorder.recordCookie(recorder, request);
        if (!recorder.isRoot()) {
            this.recordParentInfo(recorder, request);
        }
    }

    private void recordParentInfo(SpanRecorder recorder, T request) {
        String parentApplicationName = this.requestAdaptor.getHeader(request, Header.HTTP_PARENT_APPLICATION_NAME.toString());
        if (parentApplicationName != null) {
            String host = this.requestAdaptor.getHeader(request, Header.HTTP_HOST.toString());
            if (host == null) {
                host = this.requestAdaptor.getAcceptorHost(request);
            }
            recorder.recordAcceptorHost(host);
            if (this.isDebug) {
                this.logger.debug("Record acceptorHost={}", (Object)host);
            }
            String type = this.requestAdaptor.getHeader(request, Header.HTTP_PARENT_APPLICATION_TYPE.toString());
            short parentApplicationType = NumberUtils.parseShort(type, ServiceType.UNDEFINED.getCode());
            recorder.recordParentApplication(parentApplicationName, parentApplicationType);
            if (this.isDebug) {
                this.logger.debug("Record parentApplicationName={}, parentApplicationType={}", (Object)parentApplicationName, (Object)parentApplicationType);
            }
        } else if (this.isDebug) {
            this.logger.debug("Not found parentApplication");
        }
    }
}

