/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.resolver.condition;

import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.resolver.condition.Condition;
import com.navercorp.pinpoint.bootstrap.resolver.condition.ConditionValue;
import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.common.util.SystemProperty;

public class SystemPropertyCondition
implements Condition<String>,
ConditionValue<SystemProperty> {
    public static final SystemPropertyCondition INSTANCE = new SystemPropertyCondition();
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass().getName());
    private final SystemProperty property;

    private SystemPropertyCondition() {
        this(SystemProperty.INSTANCE);
    }

    @VisibleForTesting
    SystemPropertyCondition(SystemProperty property) {
        this.property = property;
    }

    @Override
    public boolean check(String requiredKey) {
        if (StringUtils.isEmpty((String)requiredKey)) {
            return false;
        }
        if (this.property.getProperty(requiredKey) != null) {
            this.logger.debug("Property '{}' found in [{}]", (Object)requiredKey, (Object)this.property.getClass().getSimpleName());
            return true;
        }
        this.logger.debug("Property '{}' not found in [{}]", (Object)requiredKey, (Object)this.property.getClass().getSimpleName());
        return false;
    }

    @Override
    public SystemProperty getValue() {
        return this.property;
    }
}

