/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.service;

import io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventEmitter<T> {
    private static final Logger log = LoggerFactory.getLogger(EventEmitter.class);
    private final StreamObserver<T> emitter;

    public EventEmitter(StreamObserver<T> emitter) {
        this.emitter = emitter;
    }

    public synchronized void onNext(T event) {
        try {
            this.emitter.onNext(event);
        }
        catch (Exception e) {
            log.warn("StreamObserver Error onNext. {}", (Object)e.getMessage());
        }
    }

    public synchronized void onCompleted() {
        try {
            this.emitter.onCompleted();
        }
        catch (Exception e) {
            log.warn("StreamObserver Error onCompleted. {}", (Object)e.getMessage());
        }
    }

    public synchronized void onError(Throwable t) {
        try {
            this.emitter.onError(t);
        }
        catch (Exception e) {
            log.warn("StreamObserver Error onError. {}", (Object)e.getMessage());
        }
    }

    public StreamObserver<T> getEmitter() {
        return this.emitter;
    }
}

