/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.consumer;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.opentelemetry.api.trace.Span;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.MapUtils;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.AsyncConsumeContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.EventMeshAction;
import org.apache.eventmesh.api.EventMeshAsyncConsumeContext;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.TopicNameHelper;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolKey;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicConf;
import org.apache.eventmesh.runtime.core.plugin.MQConsumerWrapper;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.HandleMsgContext;
import org.apache.eventmesh.runtime.core.protocol.http.push.HTTPMessageHandler;
import org.apache.eventmesh.runtime.core.protocol.http.push.MessageHandler;
import org.apache.eventmesh.runtime.core.protocol.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.TraceUtils;
import org.apache.eventmesh.spi.EventMeshExtensionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshConsumer {
    private static final Logger log = LoggerFactory.getLogger(EventMeshConsumer.class);
    private final EventMeshHTTPServer eventMeshHTTPServer;
    private final AtomicBoolean started4Persistent = new AtomicBoolean(Boolean.FALSE);
    private final AtomicBoolean started4Broadcast = new AtomicBoolean(Boolean.FALSE);
    private final AtomicBoolean inited4Persistent = new AtomicBoolean(Boolean.FALSE);
    private final AtomicBoolean inited4Broadcast = new AtomicBoolean(Boolean.FALSE);
    public final Logger messageLogger = LoggerFactory.getLogger((String)"message");
    private ConsumerGroupConf consumerGroupConf;
    private final MQConsumerWrapper persistentMqConsumer;
    private final MQConsumerWrapper broadcastMqConsumer;
    private MessageHandler httpMessageHandler;

    public EventMeshConsumer(EventMeshHTTPServer eventMeshHTTPServer, ConsumerGroupConf consumerGroupConf) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
        this.consumerGroupConf = consumerGroupConf;
        this.persistentMqConsumer = new MQConsumerWrapper(eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshStoragePluginType());
        this.broadcastMqConsumer = new MQConsumerWrapper(eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshStoragePluginType());
    }

    public synchronized void init() throws Exception {
        this.httpMessageHandler = new HTTPMessageHandler(this);
        Properties keyValue = new Properties();
        keyValue.put("isBroadcast", "false");
        keyValue.put("consumerGroup", this.consumerGroupConf.getConsumerGroup());
        keyValue.put("eventMeshIDC", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshIDC());
        keyValue.put("instanceName", EventMeshUtil.buildMeshClientID(this.consumerGroupConf.getConsumerGroup(), this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshCluster()));
        this.persistentMqConsumer.init(keyValue);
        EventListener clusterEventListener = (event, context) -> {
            block13: {
                String protocolVersion = Objects.requireNonNull(event.getSpecVersion()).toString();
                Span span = TraceUtils.prepareServerSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersion, event), "downstream-eventmesh-server-span", false);
                try {
                    Optional<Object> topicNameHelper = Optional.ofNullable(EventMeshExtensionFactory.getExtension(TopicNameHelper.class, (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshStoragePluginType()));
                    String topic = event.getSubject();
                    String bizSeqNo = Objects.requireNonNull(event.getExtension(ProtocolKey.ClientInstanceKey.BIZSEQNO.getKey())).toString();
                    String uniqueId = Objects.requireNonNull(event.getExtension(ProtocolKey.ClientInstanceKey.UNIQUEID.getKey())).toString();
                    event = CloudEventBuilder.from((CloudEvent)event).withExtension("reqmq2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).withExtension("reqreceiveeventmeship", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshServerIp()).build();
                    if (this.messageLogger.isDebugEnabled()) {
                        this.messageLogger.debug("message|mq2eventMesh|topic={}|event={}", (Object)topic, (Object)event);
                    } else {
                        this.messageLogger.info("message|mq2eventMesh|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{topic, bizSeqNo, uniqueId});
                    }
                    if (topicNameHelper.isPresent() && ((TopicNameHelper)topicNameHelper.get()).isRetryTopic(topic)) {
                        topic = String.valueOf(event.getExtension("topic"));
                    }
                    ConsumerGroupTopicConf currentTopicConfig = (ConsumerGroupTopicConf)MapUtils.getObject(this.consumerGroupConf.getConsumerGroupTopicConf(), (Object)topic, null);
                    EventMeshAsyncConsumeContext eventMeshAsyncConsumeContext = (EventMeshAsyncConsumeContext)context;
                    if (currentTopicConfig == null) {
                        try {
                            this.sendMessageBack(event, uniqueId, bizSeqNo);
                            log.warn("no ConsumerGroupTopicConf found, sendMessageBack success, consumerGroup:{}, topic:{}, bizSeqNo={}, uniqueId={}", new Object[]{this.consumerGroupConf.getConsumerGroup(), topic, bizSeqNo, uniqueId});
                        }
                        catch (Exception ex) {
                            log.warn("sendMessageBack fail, consumerGroup:{}, topic:{}, bizSeqNo={}, uniqueId={}", new Object[]{this.consumerGroupConf.getConsumerGroup(), topic, bizSeqNo, uniqueId, ex});
                        }
                        eventMeshAsyncConsumeContext.commit(EventMeshAction.CommitMessage);
                        return;
                    }
                    SubscriptionItem subscriptionItem = this.consumerGroupConf.getConsumerGroupTopicConf().get(topic).getSubscriptionItem();
                    HandleMsgContext handleMsgContext = new HandleMsgContext(EventMeshUtil.buildPushMsgSeqNo(), this.consumerGroupConf.getConsumerGroup(), this, topic, event, subscriptionItem, eventMeshAsyncConsumeContext.getAbstractContext(), this.consumerGroupConf, this.eventMeshHTTPServer, bizSeqNo, uniqueId, currentTopicConfig);
                    if (this.httpMessageHandler.handle(handleMsgContext)) {
                        eventMeshAsyncConsumeContext.commit(EventMeshAction.ManualAck);
                        break block13;
                    }
                    try {
                        this.sendMessageBack(event, uniqueId, bizSeqNo);
                    }
                    catch (Exception e) {
                        log.warn("sendMessageBack fail,topic:{}, bizSeqNo={}, uniqueId={}", new Object[]{topic, bizSeqNo, uniqueId, e});
                    }
                    eventMeshAsyncConsumeContext.commit(EventMeshAction.CommitMessage);
                }
                finally {
                    TraceUtils.finishSpan(span, event);
                }
            }
        };
        this.persistentMqConsumer.registerEventListener(clusterEventListener);
        Properties broadcastKeyValue = new Properties();
        broadcastKeyValue.put("isBroadcast", "true");
        broadcastKeyValue.put("consumerGroup", this.consumerGroupConf.getConsumerGroup());
        broadcastKeyValue.put("eventMeshIDC", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshIDC());
        broadcastKeyValue.put("instanceName", EventMeshUtil.buildMeshClientID(this.consumerGroupConf.getConsumerGroup(), this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshCluster()));
        this.broadcastMqConsumer.init(broadcastKeyValue);
        EventListener broadcastEventListener = this::lambda$init$1;
        this.broadcastMqConsumer.registerEventListener(broadcastEventListener);
        this.inited4Persistent.compareAndSet(false, true);
        this.inited4Broadcast.compareAndSet(false, true);
        log.info("EventMeshConsumer [{}] inited.............", (Object)this.consumerGroupConf.getConsumerGroup());
    }

    private String getEventExtension(CloudEvent event, String protocolKey) {
        Object extension = event.getExtension(protocolKey);
        return Objects.isNull(extension) ? "" : extension.toString();
    }

    public synchronized void start() throws Exception {
        this.persistentMqConsumer.start();
        this.started4Persistent.compareAndSet(false, true);
        this.broadcastMqConsumer.start();
        this.started4Broadcast.compareAndSet(false, true);
    }

    public void subscribe(String topic, SubscriptionItem subscriptionItem) throws Exception {
        if (SubscriptionMode.BROADCASTING != subscriptionItem.getMode()) {
            this.persistentMqConsumer.subscribe(topic);
        } else {
            this.broadcastMqConsumer.subscribe(topic);
        }
    }

    public void unsubscribe(String topic, SubscriptionMode subscriptionMode) throws Exception {
        if (SubscriptionMode.BROADCASTING == subscriptionMode) {
            this.broadcastMqConsumer.unsubscribe(topic);
        } else {
            this.persistentMqConsumer.unsubscribe(topic);
        }
    }

    public synchronized void shutdown() throws Exception {
        this.persistentMqConsumer.shutdown();
        this.started4Persistent.compareAndSet(true, false);
        this.broadcastMqConsumer.shutdown();
        this.started4Broadcast.compareAndSet(true, false);
    }

    public void updateOffset(String topic, SubscriptionMode subscriptionMode, List<CloudEvent> events, AbstractContext context) {
        if (SubscriptionMode.BROADCASTING == subscriptionMode) {
            this.broadcastMqConsumer.updateOffset(events, context);
        } else {
            this.persistentMqConsumer.updateOffset(events, context);
        }
    }

    public ConsumerGroupConf getConsumerGroupConf() {
        return this.consumerGroupConf;
    }

    public void setConsumerGroupConf(ConsumerGroupConf consumerGroupConf) {
        this.consumerGroupConf = consumerGroupConf;
    }

    public EventMeshHTTPServer getEventMeshHTTPServer() {
        return this.eventMeshHTTPServer;
    }

    public void sendMessageBack(CloudEvent event, final String uniqueId, final String bizSeqNo) throws Exception {
        EventMeshProducer sendMessageBack = this.eventMeshHTTPServer.getProducerManager().getEventMeshProducer(this.consumerGroupConf.getConsumerGroup());
        if (sendMessageBack == null) {
            log.warn("consumer:{} consume fail, sendMessageBack, bizSeqNo:{}, uniqueId:{}", new Object[]{this.consumerGroupConf.getConsumerGroup(), bizSeqNo, uniqueId});
            return;
        }
        SendMessageContext sendMessageBackContext = new SendMessageContext(bizSeqNo, event, sendMessageBack, this.eventMeshHTTPServer);
        sendMessageBack.send(sendMessageBackContext, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
            }

            public void onException(OnExceptionContext context) {
                log.warn("consumer:{} consume fail, sendMessageBack, bizSeqno:{}, uniqueId:{}", new Object[]{EventMeshConsumer.this.consumerGroupConf.getConsumerGroup(), bizSeqNo, uniqueId});
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$init$1(CloudEvent event, AsyncConsumeContext context) {
        block11: {
            protocolVersion = Objects.requireNonNull(event.getSpecVersion()).toString();
            span = TraceUtils.prepareServerSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersion, event), "downstream-eventmesh-server-span", false);
            try {
                event = CloudEventBuilder.from((CloudEvent)event).withExtension("reqmq2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).withExtension("reqreceiveeventmeship", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshServerIp()).build();
                topic = event.getSubject();
                bizSeqNo = this.getEventExtension(event, ProtocolKey.ClientInstanceKey.BIZSEQNO.getKey());
                uniqueId = this.getEventExtension(event, ProtocolKey.ClientInstanceKey.UNIQUEID.getKey());
                if (this.messageLogger.isDebugEnabled()) {
                    this.messageLogger.debug("message|mq2eventMesh|topic={}|msg={}", (Object)topic, (Object)event);
                } else {
                    this.messageLogger.info("message|mq2eventMesh|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{topic, bizSeqNo, uniqueId});
                }
                currentTopicConfig = (ConsumerGroupTopicConf)MapUtils.getObject(this.consumerGroupConf.getConsumerGroupTopicConf(), (Object)topic, null);
                eventMeshAsyncConsumeContext = (EventMeshAsyncConsumeContext)context;
                if (currentTopicConfig != null) ** GOTO lbl-1000
                EventMeshConsumer.log.error("no topicConfig found, consumerGroup:{} topic:{}", (Object)this.consumerGroupConf.getConsumerGroup(), (Object)topic);
                try {
                    this.sendMessageBack(event, uniqueId, bizSeqNo);
                    eventMeshAsyncConsumeContext.commit(EventMeshAction.CommitMessage);
                    return;
                }
                catch (Exception var10_10) {
                    subscriptionItem = this.consumerGroupConf.getConsumerGroupTopicConf().get(topic).getSubscriptionItem();
                    handleMsgContext = new HandleMsgContext(EventMeshUtil.buildPushMsgSeqNo(), this.consumerGroupConf.getConsumerGroup(), this, topic, event, subscriptionItem, eventMeshAsyncConsumeContext.getAbstractContext(), this.consumerGroupConf, this.eventMeshHTTPServer, bizSeqNo, uniqueId, currentTopicConfig);
                    if (this.httpMessageHandler.handle(handleMsgContext)) {
                        eventMeshAsyncConsumeContext.commit(EventMeshAction.ManualAck);
                        break block11;
                    }
                    try {
                        this.sendMessageBack(event, uniqueId, bizSeqNo);
                    }
                    catch (Exception var12_13) {
                        // empty catch block
                    }
                    eventMeshAsyncConsumeContext.commit(EventMeshAction.CommitMessage);
                }
            }
            finally {
                TraceUtils.finishSpan(span, event);
            }
        }
    }
}

