/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.client.HeartbeatRequestBody;
import org.apache.eventmesh.common.protocol.http.body.client.HeartbeatResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.client.HeartbeatRequestHeader;
import org.apache.eventmesh.common.protocol.http.header.client.HeartbeatResponseHeader;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.LogUtils;
import org.apache.eventmesh.metrics.api.model.HttpSummaryMetrics;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.Client;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartBeatProcessor
implements HttpRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(HeartBeatProcessor.class);
    private final transient EventMeshHTTPServer eventMeshHTTPServer;
    private final Acl acl;

    public HeartBeatProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
        this.acl = eventMeshHTTPServer.getAcl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(ChannelHandlerContext ctx, AsyncContext<HttpCommand> asyncContext) throws Exception {
        Object heartbeatEntity2;
        String localAddress = IPUtils.getLocalAddress();
        HttpCommand request = asyncContext.getRequest();
        LogUtils.info((Logger)log, (String)"cmd={}|{}|client2eventMesh|from={}|to={}", (Object[])new Object[]{RequestCode.get((Integer)Integer.valueOf(request.getRequestCode())), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), localAddress});
        HeartbeatRequestHeader heartbeatRequestHeader = (HeartbeatRequestHeader)request.getHeader();
        HeartbeatRequestBody heartbeatRequestBody = (HeartbeatRequestBody)request.getBody();
        EventMeshHTTPConfiguration httpConfiguration = this.eventMeshHTTPServer.getEventMeshHttpConfiguration();
        HeartbeatResponseHeader heartbeatResponseHeader = HeartbeatResponseHeader.buildHeader((Integer)Integer.valueOf(request.getRequestCode()), (String)httpConfiguration.getEventMeshCluster(), (String)localAddress, (String)httpConfiguration.getEventMeshEnv(), (String)httpConfiguration.getEventMeshIDC());
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{heartbeatRequestHeader.getIdc(), heartbeatRequestHeader.getPid(), heartbeatRequestHeader.getSys()}) || !StringUtils.isNumeric((CharSequence)heartbeatRequestHeader.getPid())) {
            this.completeResponse(request, asyncContext, heartbeatResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, null, HeartbeatResponseBody.class);
            return;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{heartbeatRequestBody.getClientType(), heartbeatRequestBody.getConsumerGroup()}) || CollectionUtils.isEmpty((Collection)heartbeatRequestBody.getHeartbeatEntities())) {
            this.completeResponse(request, asyncContext, heartbeatResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, null, HeartbeatResponseBody.class);
            return;
        }
        ConcurrentHashMap<String, List> tmpMap = new ConcurrentHashMap<String, List>();
        List heartbeatEntities = heartbeatRequestBody.getHeartbeatEntities();
        for (Object heartbeatEntity2 : heartbeatEntities) {
            Client client = new Client();
            client.setEnv(heartbeatRequestHeader.getEnv());
            client.setIdc(heartbeatRequestHeader.getIdc());
            client.setSys(heartbeatRequestHeader.getSys());
            client.setIp(heartbeatRequestHeader.getIp());
            client.setPid(heartbeatRequestHeader.getPid());
            client.setConsumerGroup(heartbeatRequestBody.getConsumerGroup());
            client.setTopic(heartbeatEntity2.topic);
            client.setUrl(heartbeatEntity2.url);
            client.setLastUpTime(new Date());
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{client.getTopic(), client.getUrl()})) continue;
            if (this.eventMeshHTTPServer.getEventMeshHttpConfiguration().isEventMeshServerSecurityEnable()) {
                try {
                    this.acl.doAclCheckInHttpHeartbeat(RemotingHelper.parseChannelRemoteAddr(ctx.channel()), heartbeatRequestHeader.getUsername(), heartbeatRequestHeader.getPasswd(), heartbeatRequestHeader.getSys(), client.getTopic(), Integer.parseInt(heartbeatRequestHeader.getCode()));
                }
                catch (Exception e) {
                    this.completeResponse(request, asyncContext, heartbeatResponseHeader, EventMeshRetCode.EVENTMESH_ACL_ERR, e.getMessage(), HeartbeatResponseBody.class);
                    LogUtils.warn((Logger)log, (String)"CLIENT HAS NO PERMISSION,HeartBeatProcessor subscribe failed", (Throwable)e);
                    return;
                }
            }
            String groupTopicKey = client.getConsumerGroup() + "@" + client.getTopic();
            List clients = tmpMap.computeIfAbsent(groupTopicKey, k -> new ArrayList());
            clients.add(client);
        }
        ConcurrentHashMap<String, List<Client>> clientInfoMap = this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping();
        heartbeatEntity2 = clientInfoMap;
        synchronized (heartbeatEntity2) {
            for (Map.Entry groupTopicClientMapping : tmpMap.entrySet()) {
                List<Client> localClientList = clientInfoMap.get(groupTopicClientMapping.getKey());
                if (CollectionUtils.isEmpty(localClientList)) {
                    clientInfoMap.put((String)groupTopicClientMapping.getKey(), (List<Client>)groupTopicClientMapping.getValue());
                    continue;
                }
                List tmpClientList = (List)groupTopicClientMapping.getValue();
                this.supplyClientInfoList(tmpClientList, localClientList);
                clientInfoMap.put((String)groupTopicClientMapping.getKey(), localClientList);
            }
        }
        long startTime = System.currentTimeMillis();
        HttpSummaryMetrics summaryMetrics = this.eventMeshHTTPServer.getMetrics().getSummaryMetrics();
        try {
            CompleteHandler<HttpCommand> handler = httpCommand -> {
                try {
                    LogUtils.debug((Logger)log, (String)"{}", (Object)httpCommand);
                    this.eventMeshHTTPServer.sendResponse(ctx, httpCommand.httpResponse());
                    summaryMetrics.recordHTTPReqResTimeCost(System.currentTimeMillis() - request.getReqTime());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            };
            HttpCommand responseEventMeshCommand = request.createHttpCommandResponse(EventMeshRetCode.SUCCESS);
            asyncContext.onComplete(responseEventMeshCommand, handler);
        }
        catch (Exception e) {
            this.completeResponse(request, asyncContext, heartbeatResponseHeader, EventMeshRetCode.EVENTMESH_HEARTBEAT_ERR, EventMeshRetCode.EVENTMESH_HEARTBEAT_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2), HeartbeatResponseBody.class);
            long elapsedTime = System.currentTimeMillis() - startTime;
            LogUtils.error((Logger)log, (String)"message|eventMesh2mq|REQ|ASYNC|heartBeatMessageCost={}ms", (Object)elapsedTime, (Object)e);
            summaryMetrics.recordSendMsgFailed();
            summaryMetrics.recordSendMsgCost(elapsedTime);
        }
    }

    private void supplyClientInfoList(List<Client> tmpClientList, List<Client> localClientList) {
        Objects.requireNonNull(tmpClientList, "tmpClientList can not be null");
        Objects.requireNonNull(localClientList, "localClientList can not be null");
        for (Client tmpClient : tmpClientList) {
            boolean isContains = false;
            for (Client localClient : localClientList) {
                if (!StringUtils.equals((CharSequence)localClient.getUrl(), (CharSequence)tmpClient.getUrl())) continue;
                isContains = true;
                localClient.setLastUpTime(tmpClient.getLastUpTime());
                break;
            }
            if (isContains) continue;
            localClientList.add(tmpClient);
        }
    }
}

