/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Maps;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolKey;
import org.apache.eventmesh.common.protocol.http.common.RequestURI;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.common.EventMeshTrace;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.processor.HandlerService;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.AbstractEventProcessor;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshTrace
public class RemoteSubscribeEventProcessor
extends AbstractEventProcessor {
    private static final Logger httpLogger = LoggerFactory.getLogger((String)"http");
    private static final Logger aclLogger = LoggerFactory.getLogger((String)"acl");
    private final Acl acl;

    public RemoteSubscribeEventProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        super(eventMeshHTTPServer);
        this.acl = eventMeshHTTPServer.getAcl();
    }

    @Override
    public void handler(HandlerService.HandlerSpecific handlerSpecific, HttpRequest httpRequest) throws Exception {
        AsyncContext<HttpEventWrapper> asyncContext = handlerSpecific.getAsyncContext();
        ChannelHandlerContext ctx = handlerSpecific.getCtx();
        HttpEventWrapper requestWrapper = asyncContext.getRequest();
        String localAddress = IPUtils.getLocalAddress();
        String remoteAddr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
        httpLogger.info("uri={}|{}|client2eventMesh|from={}|to={}", new Object[]{requestWrapper.getRequestURI(), "http", remoteAddr, localAddress});
        Map userRequestHeaderMap = requestWrapper.getHeaderMap();
        userRequestHeaderMap.put(ProtocolKey.ClientInstanceKey.IP.getKey(), remoteAddr);
        requestWrapper.buildSysHeaderForClient();
        Map<String, Object> responseHeaderMap = this.builderResponseHeaderMap(requestWrapper);
        Map sysHeaderMap = requestWrapper.getSysHeaderMap();
        HashMap<String, Object> responseBodyMap = new HashMap<String, Object>();
        if (this.validateSysHeader(sysHeaderMap)) {
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, responseHeaderMap, responseBodyMap, null);
            return;
        }
        byte[] requestBody = requestWrapper.getBody();
        Map requestBodyMap = Optional.ofNullable(JsonUtils.parseTypeReferenceObject((String)new String(requestBody, Constants.DEFAULT_CHARSET), (TypeReference)new TypeReference<HashMap<String, Object>>(){})).orElseGet(Maps::newHashMap);
        if (this.validatedRequestBodyMap(requestBodyMap)) {
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, responseHeaderMap, responseBodyMap, null);
            return;
        }
        String topic = JsonUtils.toJSONString(requestBodyMap.get("topic"));
        List subscriptionList = Optional.ofNullable(JsonUtils.parseTypeReferenceObject((String)topic, (TypeReference)new TypeReference<List<SubscriptionItem>>(){})).orElseGet(Collections::emptyList);
        EventMeshHTTPConfiguration eventMeshHttpConfiguration = this.eventMeshHTTPServer.getEventMeshHttpConfiguration();
        if (eventMeshHttpConfiguration.isEventMeshServerSecurityEnable()) {
            String user = sysHeaderMap.get(ProtocolKey.ClientInstanceKey.USERNAME.getKey()).toString();
            String pass = sysHeaderMap.get(ProtocolKey.ClientInstanceKey.PASSWD.getKey()).toString();
            String subsystem = sysHeaderMap.get(ProtocolKey.ClientInstanceKey.SYS.getKey()).toString();
            for (SubscriptionItem item : subscriptionList) {
                try {
                    this.acl.doAclCheckInHttpReceive(remoteAddr, user, pass, subsystem, item.getTopic(), requestWrapper.getRequestURI());
                }
                catch (Exception e) {
                    aclLogger.warn("CLIENT HAS NO PERMISSION,SubscribeProcessor subscribe failed", (Throwable)e);
                    handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_ACL_ERR, responseHeaderMap, responseBodyMap, null);
                    return;
                }
            }
        }
        long startTime = System.currentTimeMillis();
        try {
            String localUrl = "http://" + localAddress + ":" + eventMeshHttpConfiguration.getHttpServerPort() + RequestURI.PUBLISH_BRIDGE.getRequestURI();
            HashMap<String, Object> remoteBodyMap = new HashMap<String, Object>();
            remoteBodyMap.put("url", localUrl);
            remoteBodyMap.put("consumerGroup", eventMeshHttpConfiguration.getMeshGroup());
            remoteBodyMap.put("topic", requestBodyMap.get("topic"));
            String targetMesh = requestBodyMap.get("remoteMesh") == null ? "" : requestBodyMap.get("remoteMesh").toString();
            String meshAddress = this.getTargetMesh(eventMeshHttpConfiguration.getMeshGroup(), subscriptionList);
            if (StringUtils.isNotBlank((CharSequence)meshAddress)) {
                targetMesh = meshAddress;
            }
            CloseableHttpClient closeableHttpClient = this.eventMeshHTTPServer.getHttpClientPool().getClient();
            String remoteResult = RemoteSubscribeEventProcessor.post(closeableHttpClient, targetMesh, this.builderRemoteHeaderMap(localAddress), remoteBodyMap, (ResponseHandler<String>)((ResponseHandler)response -> EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Constants.DEFAULT_CHARSET)));
            Map remoteResultMap = Optional.ofNullable(JsonUtils.parseTypeReferenceObject((String)remoteResult, (TypeReference)new TypeReference<Map<String, String>>(){})).orElseGet(Maps::newHashMap);
            if (String.valueOf(EventMeshRetCode.SUCCESS.getRetCode()).equals(remoteResultMap.get("retCode"))) {
                responseBodyMap.put("retCode", EventMeshRetCode.SUCCESS.getRetCode());
                responseBodyMap.put("retMsg", EventMeshRetCode.SUCCESS.getErrMsg());
                handlerSpecific.sendResponse(responseHeaderMap, responseBodyMap);
            } else {
                handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_SUBSCRIBE_ERR, responseHeaderMap, responseBodyMap, null);
            }
        }
        catch (Exception e) {
            long endTime = System.currentTimeMillis();
            httpLogger.error("subscribe Remote|cost={}ms|topic={}", new Object[]{endTime - startTime, JsonUtils.toJSONString((Object)subscriptionList), e});
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_SUBSCRIBE_ERR, responseHeaderMap, responseBodyMap, null);
        }
    }

    @Override
    public String[] paths() {
        return new String[]{RequestURI.SUBSCRIBE_REMOTE.getRequestURI()};
    }
}

