/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.AclException;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.api.meta.bo.EventMeshServicePubTopicInfo;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolKey;
import org.apache.eventmesh.common.protocol.http.common.RequestURI;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.LogUtils;
import org.apache.eventmesh.common.utils.RandomStringUtils;
import org.apache.eventmesh.filter.pattern.Pattern;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.common.EventMeshTrace;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.processor.AsyncHttpProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.HandlerService;
import org.apache.eventmesh.runtime.core.protocol.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.transformer.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshTrace(isEnable=true)
public class SendAsyncEventProcessor
implements AsyncHttpProcessor {
    private static final Logger log = LoggerFactory.getLogger(SendAsyncEventProcessor.class);
    private final transient EventMeshHTTPServer eventMeshHTTPServer;
    private final Acl acl;

    public SendAsyncEventProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
        this.acl = eventMeshHTTPServer.getAcl();
    }

    @Override
    public void handler(final HandlerService.HandlerSpecific handlerSpecific, HttpRequest httpRequest) throws Exception {
        String sys;
        String pid;
        AsyncContext<HttpEventWrapper> asyncContext = handlerSpecific.getAsyncContext();
        ChannelHandlerContext ctx = handlerSpecific.getCtx();
        HttpEventWrapper requestWrapper = asyncContext.getRequest();
        String localAddress = IPUtils.getLocalAddress();
        LogUtils.info((Logger)log, (String)"uri={}|{}|client2eventMesh|from={}|to={}", (Object[])new Object[]{requestWrapper.getRequestURI(), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), localAddress});
        Map requestHeaderMap = requestWrapper.getHeaderMap();
        String source = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
        requestHeaderMap.put(ProtocolKey.ClientInstanceKey.IP.getKey(), source);
        requestWrapper.buildSysHeaderForClient();
        requestHeaderMap.putIfAbsent("source", source);
        requestWrapper.buildSysHeaderForCE();
        final String bizNo = requestHeaderMap.getOrDefault(ProtocolKey.ClientInstanceKey.BIZSEQNO.getKey(), RandomStringUtils.generateNum((int)32)).toString();
        final String uniqueId = requestHeaderMap.getOrDefault(ProtocolKey.ClientInstanceKey.UNIQUEID.getKey(), RandomStringUtils.generateNum((int)32)).toString();
        String ttl = ((Object)requestHeaderMap.getOrDefault("ttl", 14400000)).toString();
        requestWrapper.getSysHeaderMap().putIfAbsent(ProtocolKey.ClientInstanceKey.BIZSEQNO.getKey(), bizNo);
        requestWrapper.getSysHeaderMap().putIfAbsent(ProtocolKey.ClientInstanceKey.UNIQUEID.getKey(), uniqueId);
        requestWrapper.getSysHeaderMap().putIfAbsent("ttl", ttl);
        final HashMap<String, Object> responseHeaderMap = new HashMap<String, Object>();
        responseHeaderMap.put("uri", requestWrapper.getRequestURI());
        responseHeaderMap.put("eventmeshcluster", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshCluster());
        responseHeaderMap.put("eventmeship", localAddress);
        responseHeaderMap.put("eventmeshenv", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshEnv());
        responseHeaderMap.put("eventmeshidc", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshIDC());
        final HashMap<String, Object> responseBodyMap = new HashMap<String, Object>();
        String protocolType = requestHeaderMap.getOrDefault("protocoltype", "http").toString();
        ProtocolAdaptor httpProtocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
        CloudEvent event = httpProtocolAdaptor.toCloudEvent((ProtocolTransportObject)requestWrapper);
        if (event == null || event.getSource() == null || event.getSpecVersion() == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{event.getId(), event.getType(), event.getSubject()})) {
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, responseHeaderMap, responseBodyMap, EventMeshUtil.getCloudEventExtensionMap(SpecVersion.V1.toString(), event));
            return;
        }
        String idc = Objects.requireNonNull(event.getExtension(ProtocolKey.ClientInstanceKey.IDC.getKey())).toString();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{idc, pid = Objects.requireNonNull(event.getExtension(ProtocolKey.ClientInstanceKey.PID.getKey())).toString(), sys = Objects.requireNonNull(event.getExtension(ProtocolKey.ClientInstanceKey.SYS.getKey())).toString()}) || !StringUtils.isNumeric((CharSequence)pid)) {
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, responseHeaderMap, responseBodyMap, EventMeshUtil.getCloudEventExtensionMap(SpecVersion.V1.toString(), event));
            return;
        }
        String producerGroup = Objects.requireNonNull(event.getExtension(ProtocolKey.ClientInstanceKey.PRODUCERGROUP.getKey())).toString();
        final String topic = event.getSubject();
        Pattern filterPattern = this.eventMeshHTTPServer.getFilterEngine().getFilterPattern(producerGroup + "-" + topic);
        Transformer transformer = this.eventMeshHTTPServer.getTransformerEngine().getTransformer(producerGroup + "-" + topic);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{bizNo, uniqueId, producerGroup, topic}) || event.getData() == null) {
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, responseHeaderMap, responseBodyMap, EventMeshUtil.getCloudEventExtensionMap(SpecVersion.V1.toString(), event));
            return;
        }
        String token = Objects.requireNonNull(event.getExtension(ProtocolKey.ClientInstanceKey.TOKEN.getKey())).toString();
        if (this.eventMeshHTTPServer.getEventMeshHttpConfiguration().isEventMeshServerSecurityEnable()) {
            String remoteAddr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            String requestURI = requestWrapper.getRequestURI();
            String subsystem = Objects.requireNonNull(event.getExtension(ProtocolKey.ClientInstanceKey.SYS.getKey())).toString();
            try {
                EventMeshServicePubTopicInfo eventMeshServicePubTopicInfo = this.eventMeshHTTPServer.getEventMeshServer().getProducerTopicManager().getEventMeshServicePubTopicInfo(producerGroup);
                if (eventMeshServicePubTopicInfo == null) {
                    throw new AclException("no group register");
                }
                this.acl.doAclCheckInHttpSend(remoteAddr, token, subsystem, topic, requestURI, eventMeshServicePubTopicInfo);
            }
            catch (Exception e) {
                handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_ACL_ERR, responseHeaderMap, responseBodyMap, EventMeshUtil.getCloudEventExtensionMap(SpecVersion.V1.toString(), event));
                LogUtils.warn((Logger)log, (String)"CLIENT HAS NO PERMISSION,SendAsyncMessageProcessor send failed", (Throwable)e);
                return;
            }
        }
        if (!this.eventMeshHTTPServer.getMsgRateLimiter().tryAcquire(100L, TimeUnit.MILLISECONDS)) {
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_HTTP_MES_SEND_OVER_LIMIT_ERR, responseHeaderMap, responseBodyMap, EventMeshUtil.getCloudEventExtensionMap(SpecVersion.V1.toString(), event));
            return;
        }
        EventMeshProducer eventMeshProducer = StringUtils.isNotBlank((CharSequence)token) ? this.eventMeshHTTPServer.getProducerManager().getEventMeshProducer(producerGroup, token) : this.eventMeshHTTPServer.getProducerManager().getEventMeshProducer(producerGroup);
        if (!eventMeshProducer.isStarted()) {
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_GROUP_PRODUCER_STOPED_ERR, responseHeaderMap, responseBodyMap, EventMeshUtil.getCloudEventExtensionMap(SpecVersion.V1.toString(), event));
            return;
        }
        String content = new String(Objects.requireNonNull(event.getData()).toBytes(), StandardCharsets.UTF_8);
        if (Objects.requireNonNull(content).length() > this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshEventSize()) {
            LogUtils.error((Logger)log, (String)"Event size exceeds the limit: {}", (Object)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshEventSize());
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_SIZE_ERR, responseHeaderMap, responseBodyMap, EventMeshUtil.getCloudEventExtensionMap(SpecVersion.V1.toString(), event));
            return;
        }
        try {
            event = CloudEventBuilder.from((CloudEvent)event).withExtension("msgtype", "persistent").withExtension("reqc2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).withExtension("reqeventmesh2mqtimestamp", String.valueOf(System.currentTimeMillis())).build();
            LogUtils.debug((Logger)log, (String)"msg2MQMsg suc, bizSeqNo={}, topic={}", (Object)bizNo, (Object)topic);
        }
        catch (Exception e) {
            LogUtils.error((Logger)log, (String)"msg2MQMsg err, bizSeqNo={}, topic={}", (Object[])new Object[]{bizNo, topic, e});
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR, responseHeaderMap, responseBodyMap, EventMeshUtil.getCloudEventExtensionMap(SpecVersion.V1.toString(), event));
            return;
        }
        final SendMessageContext sendMessageContext = new SendMessageContext(bizNo, event, eventMeshProducer, this.eventMeshHTTPServer);
        this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordSendMsg();
        final long startTime = System.currentTimeMillis();
        boolean isFiltered = true;
        try {
            event = CloudEventBuilder.from((CloudEvent)sendMessageContext.getEvent()).withExtension("reqeventmesh2mqtimestamp", String.valueOf(System.currentTimeMillis())).build();
            handlerSpecific.getTraceOperation().createClientTraceOperation(EventMeshUtil.getCloudEventExtensionMap(SpecVersion.V1.toString(), event), "upstream-eventmesh-client-span", false);
            if (filterPattern != null) {
                isFiltered = filterPattern.filter(JsonUtils.toJSONString((Object)event));
            }
            if (isFiltered && transformer != null) {
                String data = transformer.transform(JsonUtils.toJSONString((Object)event));
                event = CloudEventBuilder.from((CloudEvent)event).withData(Objects.requireNonNull(JsonUtils.toJSONString((Object)data)).getBytes(StandardCharsets.UTF_8)).build();
                sendMessageContext.setEvent(event);
            }
            if (isFiltered) {
                eventMeshProducer.send(sendMessageContext, new SendCallback(){

                    public void onSuccess(SendResult sendResult) {
                        responseBodyMap.put("retCode", EventMeshRetCode.SUCCESS.getRetCode());
                        responseBodyMap.put("retMsg", EventMeshRetCode.SUCCESS.getErrMsg() + sendResult);
                        LogUtils.info((Logger)log, (String)"message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", (Object[])new Object[]{System.currentTimeMillis() - startTime, topic, bizNo, uniqueId});
                        handlerSpecific.getTraceOperation().endLatestTrace(sendMessageContext.getEvent());
                        handlerSpecific.sendResponse(responseHeaderMap, responseBodyMap);
                    }

                    public void onException(OnExceptionContext context) {
                        responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getRetCode());
                        responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace((Throwable)context.getException(), 2));
                        SendAsyncEventProcessor.this.eventMeshHTTPServer.getHttpRetryer().newTimeout(sendMessageContext, 10L, TimeUnit.SECONDS);
                        handlerSpecific.getTraceOperation().exceptionLatestTrace((Throwable)context.getException(), EventMeshUtil.getCloudEventExtensionMap(SpecVersion.V1.toString(), sendMessageContext.getEvent()));
                        handlerSpecific.sendResponse(responseHeaderMap, responseBodyMap);
                        LogUtils.error((Logger)log, (String)"message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", (Object[])new Object[]{System.currentTimeMillis() - startTime, topic, bizNo, uniqueId, context.getException()});
                    }
                });
            } else {
                LogUtils.error((Logger)log, (String)"message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}|apply filter failed", (Object[])new Object[]{System.currentTimeMillis() - startTime, topic, bizNo, uniqueId});
                handlerSpecific.getTraceOperation().endLatestTrace(sendMessageContext.getEvent());
                handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_FILTER_MSG_ERR, responseHeaderMap, responseBodyMap, EventMeshUtil.getCloudEventExtensionMap(SpecVersion.V1.toString(), event));
            }
        }
        catch (Exception ex) {
            this.eventMeshHTTPServer.getHttpRetryer().newTimeout(sendMessageContext, 10L, TimeUnit.SECONDS);
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_SEND_ASYNC_MSG_ERR, responseHeaderMap, responseBodyMap, null);
            long endTime = System.currentTimeMillis();
            LogUtils.error((Logger)log, (String)"message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", (Object[])new Object[]{endTime - startTime, topic, bizNo, uniqueId, ex});
        }
    }

    @Override
    public String[] paths() {
        return new String[]{RequestURI.PUBLISH.getRequestURI()};
    }
}

