/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.api.trace.Span;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolKey;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageRequestHeader;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageResponseHeader;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.LogUtils;
import org.apache.eventmesh.metrics.api.model.HttpSummaryMetrics;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.constants.EventMeshConstants;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.core.protocol.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.runtime.util.TraceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendAsyncMessageProcessor
implements HttpRequestProcessor {
    private static final Logger MESSAGE_LOGGER = LoggerFactory.getLogger((String)"message");
    private static final Logger HTTP_LOGGER = LoggerFactory.getLogger((String)"http");
    private static final Logger CMD_LOGGER = LoggerFactory.getLogger((String)"cmd");
    private static final Logger ACL_LOGGER = LoggerFactory.getLogger((String)"acl");
    private final EventMeshHTTPServer eventMeshHTTPServer;
    private final Acl acl;

    public SendAsyncMessageProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
        this.acl = eventMeshHTTPServer.getAcl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(ChannelHandlerContext ctx, final AsyncContext<HttpCommand> asyncContext) throws Exception {
        String content;
        String topic;
        String producerGroup;
        String uniqueId;
        String sys;
        String pid;
        String localAddress = IPUtils.getLocalAddress();
        final HttpCommand request = asyncContext.getRequest();
        String remoteAddr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
        CMD_LOGGER.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{RequestCode.get((Integer)Integer.valueOf(request.getRequestCode())), "http", remoteAddr, localAddress});
        SendMessageRequestHeader sendMessageRequestHeader = (SendMessageRequestHeader)request.getHeader();
        EventMeshHTTPConfiguration eventMeshHttpConfiguration = this.eventMeshHTTPServer.getEventMeshHttpConfiguration();
        final SendMessageResponseHeader sendMessageResponseHeader = SendMessageResponseHeader.buildHeader((Integer)Integer.valueOf(request.getRequestCode()), (String)eventMeshHttpConfiguration.getEventMeshCluster(), (String)localAddress, (String)eventMeshHttpConfiguration.getEventMeshEnv(), (String)eventMeshHttpConfiguration.getEventMeshIDC());
        String protocolType = sendMessageRequestHeader.getProtocolType();
        final String protocolVersion = sendMessageRequestHeader.getProtocolVersion();
        ProtocolAdaptor httpCommandProtocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
        CloudEvent event = httpCommandProtocolAdaptor.toCloudEvent((ProtocolTransportObject)request);
        final Span span = TraceUtils.prepareServerSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersion, event), "upstream-eventmesh-server-span", true);
        if (!ObjectUtils.allNotNull((Object[])new Object[]{event, event.getSource(), event.getSpecVersion()}) || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{event.getId(), event.getType(), event.getSubject()})) {
            this.completeResponse(request, asyncContext, sendMessageResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, null, SendMessageResponseBody.class);
            this.spanWithException(event, protocolVersion, EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR);
            return;
        }
        String idc = this.getExtension(event, ProtocolKey.ClientInstanceKey.IDC.getKey());
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{idc, pid = this.getExtension(event, ProtocolKey.ClientInstanceKey.PID.getKey()), sys = this.getExtension(event, ProtocolKey.ClientInstanceKey.SYS.getKey())}) || !StringUtils.isNumeric((CharSequence)pid)) {
            this.completeResponse(request, asyncContext, sendMessageResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, null, SendMessageResponseBody.class);
            this.spanWithException(event, protocolVersion, EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR);
            return;
        }
        final String bizNo = this.getExtension(event, "bizseqno");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{bizNo, uniqueId = this.getExtension(event, "uniqueid"), producerGroup = this.getExtension(event, "producergroup"), topic = event.getSubject()}) || event.getData() == null) {
            this.completeResponse(request, asyncContext, sendMessageResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, null, SendMessageResponseBody.class);
            this.spanWithException(event, protocolVersion, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR);
            return;
        }
        if (eventMeshHttpConfiguration.isEventMeshServerSecurityEnable()) {
            String user = this.getExtension(event, ProtocolKey.ClientInstanceKey.USERNAME.getKey());
            String pass = this.getExtension(event, ProtocolKey.ClientInstanceKey.PASSWD.getKey());
            String subsystem = this.getExtension(event, ProtocolKey.ClientInstanceKey.SYS.getKey());
            int requestCode = Integer.parseInt(request.getRequestCode());
            try {
                this.acl.doAclCheckInHttpSend(remoteAddr, user, pass, subsystem, topic, requestCode);
            }
            catch (Exception e) {
                this.completeResponse(request, asyncContext, sendMessageResponseHeader, EventMeshRetCode.EVENTMESH_ACL_ERR, e.getMessage(), SendMessageResponseBody.class);
                ACL_LOGGER.warn("CLIENT HAS NO PERMISSION,SendAsyncMessageProcessor send failed", (Throwable)e);
                this.spanWithException(event, protocolVersion, EventMeshRetCode.EVENTMESH_ACL_ERR);
                return;
            }
        }
        final HttpSummaryMetrics summaryMetrics = this.eventMeshHTTPServer.getMetrics().getSummaryMetrics();
        if (!this.eventMeshHTTPServer.getMsgRateLimiter().tryAcquire(100L, TimeUnit.MILLISECONDS)) {
            this.completeResponse(request, asyncContext, sendMessageResponseHeader, EventMeshRetCode.EVENTMESH_HTTP_MES_SEND_OVER_LIMIT_ERR, null, SendMessageResponseBody.class);
            summaryMetrics.recordHTTPDiscard();
            this.spanWithException(event, protocolVersion, EventMeshRetCode.EVENTMESH_HTTP_MES_SEND_OVER_LIMIT_ERR);
            return;
        }
        EventMeshProducer eventMeshProducer = this.eventMeshHTTPServer.getProducerManager().getEventMeshProducer(producerGroup);
        if (!eventMeshProducer.isStarted()) {
            this.completeResponse(request, asyncContext, sendMessageResponseHeader, EventMeshRetCode.EVENTMESH_GROUP_PRODUCER_STOPED_ERR, null, SendMessageResponseBody.class);
            this.spanWithException(event, protocolVersion, EventMeshRetCode.EVENTMESH_GROUP_PRODUCER_STOPED_ERR);
            return;
        }
        String ttl = String.valueOf(EventMeshConstants.DEFAULT_MSG_TTL_MILLS);
        String ttlExt = this.getExtension(event, "ttl");
        if (StringUtils.isBlank((CharSequence)ttlExt) && !StringUtils.isNumeric((CharSequence)ttlExt)) {
            event = CloudEventBuilder.from((CloudEvent)event).withExtension("ttl", ttl).build();
        }
        String string = content = event.getData() == null ? "" : new String(Objects.requireNonNull(event.getData()).toBytes(), Constants.DEFAULT_CHARSET);
        if (content.length() > eventMeshHttpConfiguration.getEventMeshEventSize()) {
            HTTP_LOGGER.error("Event size exceeds the limit: {}", (Object)eventMeshHttpConfiguration.getEventMeshEventSize());
            this.completeResponse(request, asyncContext, sendMessageResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_SIZE_ERR, "Event size exceeds the limit: " + eventMeshHttpConfiguration.getEventMeshEventSize(), SendMessageResponseBody.class);
            this.spanWithException(event, protocolVersion, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_SIZE_ERR);
            return;
        }
        try {
            event = CloudEventBuilder.from((CloudEvent)event).withExtension("msgtype", "persistent").withExtension("reqc2eventmeshtimestamp", (Number)request.reqTime).withExtension("reqsendeventmeship", eventMeshHttpConfiguration.getEventMeshServerIp()).build();
            LogUtils.debug((Logger)MESSAGE_LOGGER, (String)"msg2MQMsg suc, bizSeqNo={}, topic={}", (Object)bizNo, (Object)topic);
        }
        catch (Exception e) {
            MESSAGE_LOGGER.error("msg2MQMsg err, bizSeqNo={}, topic={}", new Object[]{bizNo, topic, e});
            this.completeResponse(request, asyncContext, sendMessageResponseHeader, EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR, EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2), SendMessageResponseBody.class);
            this.spanWithException(event, protocolVersion, EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR);
            return;
        }
        final SendMessageContext sendMessageContext = new SendMessageContext(bizNo, event, eventMeshProducer, this.eventMeshHTTPServer);
        summaryMetrics.recordSendMsg();
        final long startTime = System.currentTimeMillis();
        final CompleteHandler<HttpCommand> handler = httpCommand -> {
            try {
                LogUtils.debug((Logger)HTTP_LOGGER, (String)"{}", (Object)httpCommand);
                this.eventMeshHTTPServer.sendResponse(ctx, httpCommand.httpResponse());
                summaryMetrics.recordHTTPReqResTimeCost(System.currentTimeMillis() - request.getReqTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        try {
            event = CloudEventBuilder.from((CloudEvent)sendMessageContext.getEvent()).withExtension("reqeventmesh2mqtimestamp", String.valueOf(System.currentTimeMillis())).build();
            sendMessageContext.setEvent(event);
            Span clientSpan = TraceUtils.prepareClientSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersion, event), "upstream-eventmesh-client-span", false);
            try {
                eventMeshProducer.send(sendMessageContext, new SendCallback(){

                    public void onSuccess(SendResult sendResult) {
                        HttpCommand succ = request.createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.SUCCESS.getRetCode(), (String)(EventMeshRetCode.SUCCESS.getErrMsg() + sendResult)));
                        asyncContext.onComplete(succ, handler);
                        long endTime = System.currentTimeMillis();
                        summaryMetrics.recordSendMsgCost(endTime - startTime);
                        MESSAGE_LOGGER.info("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, bizNo, uniqueId});
                        TraceUtils.finishSpan(span, sendMessageContext.getEvent());
                    }

                    public void onException(OnExceptionContext context) {
                        HttpCommand err = request.createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace((Throwable)context.getException(), 2))));
                        asyncContext.onComplete(err, handler);
                        SendAsyncMessageProcessor.this.eventMeshHTTPServer.getHttpRetryer().newTimeout(sendMessageContext, 10L, TimeUnit.SECONDS);
                        long endTime = System.currentTimeMillis();
                        summaryMetrics.recordSendMsgFailed();
                        summaryMetrics.recordSendMsgCost(endTime - startTime);
                        MESSAGE_LOGGER.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, bizNo, uniqueId, context.getException()});
                        TraceUtils.finishSpanWithException(span, EventMeshUtil.getCloudEventExtensionMap(protocolVersion, sendMessageContext.getEvent()), EventMeshRetCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getErrMsg(), (Throwable)context.getException());
                    }
                });
            }
            finally {
                TraceUtils.finishSpan(clientSpan, event);
            }
        }
        catch (Exception ex) {
            this.completeResponse(request, asyncContext, sendMessageResponseHeader, EventMeshRetCode.EVENTMESH_SEND_ASYNC_MSG_ERR, null, SendMessageResponseBody.class);
            this.spanWithException(event, protocolVersion, EventMeshRetCode.EVENTMESH_SEND_ASYNC_MSG_ERR);
            this.eventMeshHTTPServer.getHttpRetryer().newTimeout(sendMessageContext, 10L, TimeUnit.SECONDS);
            long endTime = System.currentTimeMillis();
            MESSAGE_LOGGER.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, bizNo, uniqueId, ex});
            summaryMetrics.recordSendMsgFailed();
            summaryMetrics.recordSendMsgCost(endTime - startTime);
        }
    }

    private void spanWithException(CloudEvent event, String protocolVersion, EventMeshRetCode retCode) {
        Span excepSpan = TraceUtils.prepareServerSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersion, event), "upstream-eventmesh-server-span", false);
        TraceUtils.finishSpanWithException(excepSpan, EventMeshUtil.getCloudEventExtensionMap(protocolVersion, event), retCode.getErrMsg(), null);
    }
}

