/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.producer;

import java.util.Properties;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.runtime.common.ServiceState;
import org.apache.eventmesh.runtime.core.consumergroup.ProducerGroupConf;
import org.apache.eventmesh.runtime.core.plugin.MQProducerWrapper;
import org.apache.eventmesh.runtime.core.protocol.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshProducer {
    private static final Logger log = LoggerFactory.getLogger(EventMeshProducer.class);
    private ProducerGroupConf producerGroupConfig;
    private MQProducerWrapper mqProducerWrapper;
    private ServiceState serviceState;

    public void send(SendMessageContext sendMsgContext, SendCallback sendCallback) throws Exception {
        this.mqProducerWrapper.send(sendMsgContext.getEvent(), sendCallback);
    }

    public void request(SendMessageContext sendMsgContext, RequestReplyCallback rrCallback, long timeout) throws Exception {
        this.mqProducerWrapper.request(sendMsgContext.getEvent(), rrCallback, timeout);
    }

    public void reply(SendMessageContext sendMessageContext, SendCallback sendCallback) throws Exception {
        this.mqProducerWrapper.reply(sendMessageContext.getEvent(), sendCallback);
    }

    public synchronized void init(CommonConfiguration configuration, ProducerGroupConf producerGroupConfig) throws Exception {
        if (ServiceState.INITED == this.serviceState) {
            return;
        }
        this.producerGroupConfig = producerGroupConfig;
        Properties keyValue = new Properties();
        keyValue.put("producerGroup", producerGroupConfig.getGroupName());
        keyValue.put("instanceName", EventMeshUtil.buildMeshClientID(producerGroupConfig.getGroupName(), configuration.getEventMeshCluster()));
        keyValue.put("eventMeshIDC", configuration.getEventMeshIDC());
        this.mqProducerWrapper = new MQProducerWrapper(configuration.getEventMeshStoragePluginType());
        this.mqProducerWrapper.init(keyValue);
        this.serviceState = ServiceState.INITED;
        log.info("EventMeshProducer [{}] inited...........", (Object)producerGroupConfig.getGroupName());
    }

    public synchronized void start() throws Exception {
        if (this.serviceState == null || ServiceState.RUNNING == this.serviceState) {
            return;
        }
        this.mqProducerWrapper.start();
        this.serviceState = ServiceState.RUNNING;
        log.info("EventMeshProducer [{}] started..........", (Object)this.producerGroupConfig.getGroupName());
    }

    public synchronized void shutdown() throws Exception {
        if (this.serviceState == null || ServiceState.STOPPED == this.serviceState) {
            return;
        }
        this.mqProducerWrapper.shutdown();
        this.serviceState = ServiceState.STOPPED;
        log.info("EventMeshProducer [{}] shutdown.........", (Object)this.producerGroupConfig.getGroupName());
    }

    public ServiceState getStatus() {
        return this.serviceState;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("eventMeshProducer={").append("status=").append(this.serviceState.name()).append(",").append("producerGroupConfig=").append(this.producerGroupConfig).append("}");
        return sb.toString();
    }

    public MQProducerWrapper getMqProducerWrapper() {
        return this.mqProducerWrapper;
    }

    public boolean isStarted() {
        return this.serviceState == ServiceState.RUNNING;
    }
}

