/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.processor;

import io.netty.channel.ChannelHandlerContext;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.processor.TcpProcessor;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push.DownStreamMsgContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageAckProcessor
implements TcpProcessor {
    private static final Logger log = LoggerFactory.getLogger(MessageAckProcessor.class);
    private static final Logger MESSAGE_LOGGER = LoggerFactory.getLogger((String)"message");
    private EventMeshTCPServer eventMeshTCPServer;
    private final Acl acl;

    public MessageAckProcessor(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
        this.acl = eventMeshTCPServer.getAcl();
    }

    @Override
    public void process(Package pkg, ChannelHandlerContext ctx, long startTime) {
        Session session = this.eventMeshTCPServer.getClientSessionGroupMapping().getSession(ctx);
        long taskExecuteTime = System.currentTimeMillis();
        String seq = pkg.getHeader().getSeq();
        Command cmd = pkg.getHeader().getCmd();
        if (seq == null) {
            log.error("MessageAckTask failed, seq cannot be null|user={}", (Object)session.getClient());
            return;
        }
        DownStreamMsgContext downStreamMsgContext = session.getPusher().getUnAckMsg().get(seq);
        if (downStreamMsgContext != null) {
            downStreamMsgContext.ackMsg();
            session.getPusher().getUnAckMsg().remove(seq);
        } else if (cmd != Command.RESPONSE_TO_CLIENT_ACK) {
            log.warn("MessageAckTask, seq:{}, downStreamMsgContext not in downStreamMap,client:{}", (Object)seq, (Object)session.getClient());
        }
        MESSAGE_LOGGER.info("pkg|c2eventMesh|cmd={}|seq=[{}]|user={}|wait={}ms|cost={}ms", new Object[]{cmd, seq, session.getClient(), taskExecuteTime - startTime, System.currentTimeMillis() - startTime});
    }
}

