/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.processor;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientGroupWrapper;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.processor.TcpProcessor;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.EventMeshTcpSendResult;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.EventMeshTcpSendStatus;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.UpStreamMsgContext;
import org.apache.eventmesh.runtime.trace.AttributeKeys;
import org.apache.eventmesh.runtime.trace.SpanKey;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.runtime.util.TraceUtils;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTransferProcessor
implements TcpProcessor {
    private static final Logger log = LoggerFactory.getLogger(MessageTransferProcessor.class);
    private static final Logger MESSAGE_LOGGER = LoggerFactory.getLogger((String)"message");
    private EventMeshTCPServer eventMeshTCPServer;
    private final Acl acl;
    private Package pkg;
    private ChannelHandlerContext ctx;
    private Session session;
    private long startTime;

    public MessageTransferProcessor(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
        this.acl = eventMeshTCPServer.getAcl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Package pkg, ChannelHandlerContext ctx, long startTime) {
        block14: {
            Session session = this.eventMeshTCPServer.getClientSessionGroupMapping().getSession(ctx);
            this.pkg = pkg;
            this.ctx = ctx;
            this.session = session;
            this.startTime = startTime;
            long taskExecuteTime = System.currentTimeMillis();
            Command cmd = pkg.getHeader().getCmd();
            try {
                if (this.eventMeshTCPServer.getEventMeshTCPConfiguration().isEventMeshServerTraceEnable() && Command.RESPONSE_TO_SERVER != cmd) {
                    Span span = TraceUtils.prepareServerSpan(pkg.getHeader().getProperties(), "upstream-eventmesh-server-span", startTime, TimeUnit.MILLISECONDS, true);
                    Context context = Context.current().with(SpanKey.SERVER_KEY, (Object)span);
                    ctx.channel().attr(AttributeKeys.SERVER_CONTEXT).set((Object)context);
                }
            }
            catch (Exception ex) {
                log.warn("upload trace fail in MessageTransferTask[server-span-start]", (Throwable)ex);
            }
            Command replyCmd = this.getReplyCmd(cmd);
            Package msg = new Package();
            CloudEvent event = null;
            try {
                ProtocolAdaptor protocolAdaptor;
                String protocolType = "eventmeshmessage";
                if (pkg.getHeader().getProperties() != null && pkg.getHeader().getProperty("protocoltype") != null) {
                    protocolType = (String)pkg.getHeader().getProperty("protocoltype");
                }
                if ((event = (protocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType)).toCloudEvent((ProtocolTransportObject)pkg)) == null) {
                    throw new Exception("event is null");
                }
                String content = new String(Objects.requireNonNull(event.getData()).toBytes(), StandardCharsets.UTF_8);
                int eventMeshEventSize = this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshEventSize();
                if (content.length() > eventMeshEventSize) {
                    throw new Exception("event size exceeds the limit: " + eventMeshEventSize);
                }
                if (this.eventMeshTCPServer.getEventMeshTCPConfiguration().isEventMeshServerSecurityEnable()) {
                    String remoteAddr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
                    this.acl.doAclCheckInTcpSend(remoteAddr, session.getClient(), event.getSubject(), cmd.getValue());
                }
                if (!this.eventMeshTCPServer.getRateLimiter().tryAcquire(5L, TimeUnit.MILLISECONDS)) {
                    msg.setHeader(new Header(replyCmd, OPStatus.FAIL.getCode().intValue(), "Tps overload, global flow control", pkg.getHeader().getSeq()));
                    ctx.writeAndFlush((Object)msg).addListener((GenericFutureListener)((ChannelFutureListener)future -> Utils.logSucceedMessageFlow(msg, session.getClient(), startTime, taskExecuteTime)));
                    TraceUtils.finishSpanWithException(ctx, event, "Tps overload, global flow control", null);
                    log.warn("======Tps overload, global flow control, rate:{}! PLEASE CHECK!========", (Object)this.eventMeshTCPServer.getRateLimiter().getRate());
                    return;
                }
                Session session2 = session;
                synchronized (session2) {
                    long sendTime = System.currentTimeMillis();
                    event = this.addTimestamp(event, cmd, sendTime);
                    EventMeshTcpSendResult sendStatus = session.upstreamMsg(pkg.getHeader(), event, this.createSendCallback(replyCmd, taskExecuteTime, event), startTime, taskExecuteTime);
                    if (!StringUtils.equals((CharSequence)EventMeshTcpSendStatus.SUCCESS.name(), (CharSequence)sendStatus.getSendStatus().name())) {
                        throw new Exception(sendStatus.getDetail());
                    }
                    MESSAGE_LOGGER.info("pkg|eventMesh2mq|cmd={}|Msg={}|user={}|wait={}ms|cost={}ms", new Object[]{cmd, event, session.getClient(), taskExecuteTime - startTime, sendTime - startTime});
                }
            }
            catch (Exception e) {
                log.error("MessageTransferTask failed|cmd={}|event={}|user={}", new Object[]{cmd, event, session.getClient(), e});
                if (cmd == Command.RESPONSE_TO_SERVER) break block14;
                msg.setHeader(new Header(replyCmd, OPStatus.FAIL.getCode().intValue(), e.toString(), pkg.getHeader().getSeq()));
                Utils.writeAndFlush(msg, startTime, taskExecuteTime, session.getContext(), session);
                if (event == null) break block14;
                TraceUtils.finishSpanWithException(ctx, event, "MessageTransferTask failed", (Throwable)e);
            }
        }
    }

    private CloudEvent addTimestamp(CloudEvent event, Command cmd, long sendTime) {
        if (cmd == Command.RESPONSE_TO_SERVER) {
            return this.buildCloudEventWithTimestamps(event, "rspc2eventmeshtimestamp", "rspeventmesh2mqtimestamp", sendTime, "rspsendeventmeship");
        }
        return this.buildCloudEventWithTimestamps(event, "reqc2eventmeshtimestamp", "reqeventmesh2mqtimestamp", sendTime, "reqsendeventmeship");
    }

    private CloudEvent buildCloudEventWithTimestamps(CloudEvent event, String client2EventMeshTime, String eventMesh2MqTime, long sendTime, String eventMeshIP) {
        return CloudEventBuilder.from((CloudEvent)event).withExtension(client2EventMeshTime, String.valueOf(this.startTime)).withExtension(eventMesh2MqTime, String.valueOf(sendTime)).withExtension(eventMeshIP, this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshServerIp()).build();
    }

    private Command getReplyCmd(Command cmd) {
        switch (cmd) {
            case REQUEST_TO_SERVER: {
                return Command.RESPONSE_TO_CLIENT;
            }
            case ASYNC_MESSAGE_TO_SERVER: {
                return Command.ASYNC_MESSAGE_TO_SERVER_ACK;
            }
            case BROADCAST_MESSAGE_TO_SERVER: {
                return Command.BROADCAST_MESSAGE_TO_SERVER_ACK;
            }
        }
        return cmd;
    }

    protected SendCallback createSendCallback(final Command replyCmd, final long taskExecuteTime, final CloudEvent event) {
        final long createTime = System.currentTimeMillis();
        final Package msg = new Package();
        return new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                MessageTransferProcessor.this.session.getSender().getUpstreamBuff().release();
                MESSAGE_LOGGER.info("upstreamMsg message success|user={}|callback cost={}", (Object)MessageTransferProcessor.this.session.getClient(), (Object)(System.currentTimeMillis() - createTime));
                if (replyCmd == Command.BROADCAST_MESSAGE_TO_SERVER_ACK || replyCmd == Command.ASYNC_MESSAGE_TO_SERVER_ACK) {
                    msg.setHeader(new Header(replyCmd, OPStatus.SUCCESS.getCode().intValue(), OPStatus.SUCCESS.getDesc(), MessageTransferProcessor.this.pkg.getHeader().getSeq()));
                    msg.setBody((Object)event);
                    Utils.writeAndFlush(msg, MessageTransferProcessor.this.startTime, taskExecuteTime, MessageTransferProcessor.this.session.getContext(), MessageTransferProcessor.this.session);
                    TraceUtils.finishSpan(MessageTransferProcessor.this.ctx, event);
                }
            }

            public void onException(OnExceptionContext context) {
                MessageTransferProcessor.this.session.getSender().getUpstreamBuff().release();
                UpStreamMsgContext upStreamMsgContext = new UpStreamMsgContext(MessageTransferProcessor.this.session, event, MessageTransferProcessor.this.pkg.getHeader(), MessageTransferProcessor.this.startTime, taskExecuteTime);
                ((ClientGroupWrapper)Objects.requireNonNull(MessageTransferProcessor.this.session.getClientGroupWrapper().get())).getTcpRetryer().newTimeout(upStreamMsgContext, 10L, TimeUnit.SECONDS);
                MessageTransferProcessor.this.session.getSender().getFailMsgCount().incrementAndGet();
                MESSAGE_LOGGER.error("upstreamMsg mq message error|user={}|callback cost={}, errMsg={}", new Object[]{MessageTransferProcessor.this.session.getClient(), System.currentTimeMillis() - createTime, new Exception((Throwable)context.getException())});
                msg.setHeader(new Header(replyCmd, OPStatus.FAIL.getCode().intValue(), context.getException().toString(), MessageTransferProcessor.this.pkg.getHeader().getSeq()));
                msg.setBody((Object)event);
                Utils.writeAndFlush(msg, MessageTransferProcessor.this.startTime, taskExecuteTime, MessageTransferProcessor.this.session.getContext(), MessageTransferProcessor.this.session);
                if (replyCmd != Command.RESPONSE_TO_SERVER) {
                    TraceUtils.finishSpanWithException(MessageTransferProcessor.this.ctx, event, "upload trace fail in MessageTransferTask.createSendCallback.onException", (Throwable)context.getException());
                }
            }
        };
    }
}

