/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.processor;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.eventmesh.api.exception.AclException;
import org.apache.eventmesh.api.meta.bo.EventMeshAppSubTopicInfo;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.Subscription;
import org.apache.eventmesh.common.utils.LogUtils;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.processor.TcpProcessor;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeProcessor
implements TcpProcessor {
    private static final Logger log = LoggerFactory.getLogger(SubscribeProcessor.class);
    private final Acl acl;
    private EventMeshTCPServer eventMeshTCPServer;

    public SubscribeProcessor(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
        this.acl = eventMeshTCPServer.getAcl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Package pkg, ChannelHandlerContext ctx, long startTime) {
        Session session = this.eventMeshTCPServer.getClientSessionGroupMapping().getSession(ctx);
        long taskExecuteTime = System.currentTimeMillis();
        Package msg = new Package();
        try {
            Subscription subscriptionInfo = (Subscription)pkg.getBody();
            Objects.requireNonNull(subscriptionInfo, "subscriptionInfo can not be null");
            ArrayList<SubscriptionItem> subscriptionItems = new ArrayList<SubscriptionItem>();
            boolean eventMeshServerSecurityEnable = this.eventMeshTCPServer.getEventMeshTCPConfiguration().isEventMeshServerSecurityEnable();
            String remoteAddr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            String group = session.getClient().getGroup();
            String token = session.getClient().getToken();
            String subsystem = session.getClient().getSubsystem();
            subscriptionInfo.getTopicList().forEach(item -> {
                if (eventMeshServerSecurityEnable) {
                    try {
                        EventMeshAppSubTopicInfo eventMeshAppSubTopicInfo = this.eventMeshTCPServer.getMetaStorage().findEventMeshAppSubTopicInfo(group);
                        if (eventMeshAppSubTopicInfo == null) {
                            throw new AclException("no group register");
                        }
                        this.acl.doAclCheckInTcpReceive(remoteAddr, token, subsystem, item.getTopic(), null, eventMeshAppSubTopicInfo);
                    }
                    catch (Exception e) {
                        throw new AclException("group:" + session.getClient().getGroup() + " has no auth to sub the topic:" + item.getTopic());
                    }
                }
                subscriptionItems.add((SubscriptionItem)item);
            });
            Session session2 = session;
            synchronized (session2) {
                session.subscribe(subscriptionItems);
                LogUtils.info((Logger)log, (String)"SubscribeTask succeed|user={}|topics={}", (Object)session.getClient(), subscriptionItems);
            }
            this.eventMeshTCPServer.getClientSessionGroupMapping().updateMetaData();
            msg.setHeader(new Header(Command.SUBSCRIBE_RESPONSE, OPStatus.SUCCESS.getCode().intValue(), OPStatus.SUCCESS.getDesc(), pkg.getHeader().getSeq()));
        }
        catch (Exception e) {
            log.error("SubscribeTask failed|user={}|errMsg={}", (Object)session.getClient(), (Object)e);
            msg.setHeader(new Header(Command.SUBSCRIBE_RESPONSE, OPStatus.FAIL.getCode().intValue(), e.toString(), pkg.getHeader().getSeq()));
        }
        finally {
            Utils.writeAndFlush(msg, startTime, taskExecuteTime, session.getContext(), session);
        }
    }
}

