/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.opentelemetry.api.trace.Span;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.SubscriptionType;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientGroupWrapper;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push.DownStreamMsgContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.TraceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionPusher {
    private static final Logger log = LoggerFactory.getLogger(SessionPusher.class);
    private final Logger messageLogger = LoggerFactory.getLogger((String)"message");
    private final AtomicLong deliveredMsgsCount = new AtomicLong(0L);
    private final AtomicLong deliverFailMsgsCount = new AtomicLong(0L);
    private final ConcurrentHashMap<String, DownStreamMsgContext> downStreamMap = new ConcurrentHashMap();
    private final Session session;

    public SessionPusher(Session session) {
        this.session = session;
    }

    public String toString() {
        return "SessionPusher{deliveredMsgsCount=" + this.deliveredMsgsCount.longValue() + ",deliverFailCount=" + this.deliverFailMsgsCount.longValue() + ",unAckMsg=" + CollectionUtils.size(this.downStreamMap) + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(DownStreamMsgContext downStreamMsgContext) {
        Command cmd = SubscriptionMode.BROADCASTING == downStreamMsgContext.getSubscriptionItem().getMode() ? Command.BROADCAST_MESSAGE_TO_CLIENT : (SubscriptionType.SYNC == downStreamMsgContext.getSubscriptionItem().getType() ? Command.REQUEST_TO_CLIENT : Command.ASYNC_MESSAGE_TO_CLIENT);
        String protocolType = Objects.requireNonNull(downStreamMsgContext.event.getExtension("protocoltype")).toString();
        ProtocolAdaptor protocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
        Package pkg = new Package();
        downStreamMsgContext.event = CloudEventBuilder.from((CloudEvent)downStreamMsgContext.event).withExtension("reqeventmesh2ctimestamp", String.valueOf(System.currentTimeMillis())).withExtension("rsp0sys", this.session.getClient().getSubsystem()).withExtension("rsp0group", this.session.getClient().getGroup()).withExtension("rsp0idc", this.session.getClient().getIdc()).withExtension("rsp0ip", this.session.getClient().getHost()).build();
        try {
            pkg = (Package)protocolAdaptor.fromCloudEvent(downStreamMsgContext.event);
            pkg.setHeader(new Header(cmd, OPStatus.SUCCESS.getCode().intValue(), null, downStreamMsgContext.seq));
            pkg.getHeader().putProperty("protocoltype", (Object)protocolType);
            this.messageLogger.info("pkg|mq2eventMesh|cmd={}|mqMsg={}|user={}", new Object[]{cmd, pkg, this.session.getClient()});
        }
        catch (Exception e) {
            pkg.setHeader(new Header(cmd, OPStatus.FAIL.getCode().intValue(), Arrays.toString(e.getStackTrace()), downStreamMsgContext.seq));
        }
        finally {
            ((ClientGroupWrapper)Objects.requireNonNull(this.session.getClientGroupWrapper().get())).getEventMeshTcpMonitor().getTcpSummaryMetrics().getEventMesh2clientMsgNum().incrementAndGet();
            String protocolVersion = Objects.requireNonNull(downStreamMsgContext.event.getSpecVersion()).toString();
            Span span = TraceUtils.prepareClientSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersion, downStreamMsgContext.event), "downstream-eventmesh-client-span", false);
            try {
                this.session.getContext().writeAndFlush((Object)pkg).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                    if (!future.isSuccess()) {
                        log.error("downstreamMsg fail,seq:{}, retryTimes:{}, event:{}", new Object[]{downStreamMsgContext.seq, downStreamMsgContext.retryTimes, downStreamMsgContext.event});
                        this.deliverFailMsgsCount.incrementAndGet();
                        long isolateTime = System.currentTimeMillis() + (long)this.session.getEventMeshTCPConfiguration().getEventMeshTcpPushFailIsolateTimeInMills();
                        this.session.setIsolateTime(isolateTime);
                        log.warn("isolate client:{},isolateTime:{}", (Object)this.session.getClient(), (Object)isolateTime);
                        long delayTime = SubscriptionType.SYNC == downStreamMsgContext.getSubscriptionItem().getType() ? (long)this.session.getEventMeshTCPConfiguration().getEventMeshTcpMsgRetrySyncDelayInMills() : (long)this.session.getEventMeshTCPConfiguration().getEventMeshTcpMsgRetryAsyncDelayInMills();
                        ((ClientGroupWrapper)Objects.requireNonNull(this.session.getClientGroupWrapper().get())).getTcpRetryer().newTimeout(downStreamMsgContext, delayTime, TimeUnit.MILLISECONDS);
                    } else {
                        this.deliveredMsgsCount.incrementAndGet();
                        log.info("downstreamMsg success,seq:{}, retryTimes:{}, bizSeq:{}", new Object[]{downStreamMsgContext.seq, downStreamMsgContext.retryTimes, EventMeshUtil.getMessageBizSeq(downStreamMsgContext.event)});
                        if (this.session.isIsolated()) {
                            log.info("cancel isolated,client:{}", (Object)this.session.getClient());
                            this.session.setIsolateTime(System.currentTimeMillis());
                        }
                    }
                }));
            }
            finally {
                TraceUtils.finishSpan(span, downStreamMsgContext.event);
            }
        }
    }

    public void unAckMsg(String seq, DownStreamMsgContext downStreamMsgContext) {
        this.downStreamMap.put(seq, downStreamMsgContext);
        log.info("put msg in unAckMsg,seq:{},unAckMsgSize:{}", (Object)seq, (Object)this.getTotalUnackMsgs());
    }

    public int getTotalUnackMsgs() {
        return this.downStreamMap.size();
    }

    public ConcurrentHashMap<String, DownStreamMsgContext> getUnAckMsg() {
        return this.downStreamMap;
    }

    public AtomicLong getDeliveredMsgsCount() {
        return this.deliveredMsgsCount;
    }

    public AtomicLong getDeliverFailMsgsCount() {
        return this.deliverFailMsgsCount;
    }
}

