/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.meta;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.exception.MetaException;
import org.apache.eventmesh.api.meta.MetaService;
import org.apache.eventmesh.api.meta.MetaServiceListener;
import org.apache.eventmesh.api.meta.bo.EventMeshAppSubTopicInfo;
import org.apache.eventmesh.api.meta.bo.EventMeshServicePubTopicInfo;
import org.apache.eventmesh.api.meta.dto.EventMeshDataInfo;
import org.apache.eventmesh.api.meta.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.meta.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.spi.EventMeshExtensionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStorage {
    private static final Logger log = LoggerFactory.getLogger(MetaStorage.class);
    private static final Map<String, MetaStorage> META_CACHE = new HashMap<String, MetaStorage>(16);
    private MetaService metaService;
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    private MetaStorage() {
    }

    public static MetaStorage getInstance(String metaPluginType) {
        return META_CACHE.computeIfAbsent(metaPluginType, MetaStorage::metaStorageBuilder);
    }

    private static MetaStorage metaStorageBuilder(String metaPluginType) {
        MetaService metaServiceExt = (MetaService)EventMeshExtensionFactory.getExtension(MetaService.class, (String)metaPluginType);
        if (metaServiceExt == null) {
            String errorMsg = "can't load the metaService plugin, please check.";
            log.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        MetaStorage metaStorage = new MetaStorage();
        metaStorage.metaService = metaServiceExt;
        return metaStorage;
    }

    public void init() throws MetaException {
        if (!this.inited.compareAndSet(false, true)) {
            return;
        }
        this.metaService.init();
    }

    public void start() throws MetaException {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.metaService.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws MetaException {
        this.inited.compareAndSet(true, false);
        this.started.compareAndSet(true, false);
        if (!this.shutdown.compareAndSet(false, true)) {
            return;
        }
        MetaStorage metaStorage = this;
        synchronized (metaStorage) {
            this.metaService.shutdown();
        }
    }

    public List<EventMeshDataInfo> findEventMeshInfoByCluster(String clusterName) throws MetaException {
        return this.metaService.findEventMeshInfoByCluster(clusterName);
    }

    public List<EventMeshDataInfo> findAllEventMeshInfo() throws MetaException {
        return this.metaService.findAllEventMeshInfo();
    }

    public Map<String, Map<String, Integer>> findEventMeshClientDistributionData(String clusterName, String group, String purpose) throws MetaException {
        return this.metaService.findEventMeshClientDistributionData(clusterName, group, purpose);
    }

    public void registerMetadata(Map<String, String> metadata) {
        this.metaService.registerMetadata(metadata);
    }

    public void updateMetaData(Map<String, String> metadata) {
        this.metaService.updateMetaData(metadata);
    }

    public boolean register(EventMeshRegisterInfo eventMeshRegisterInfo) throws MetaException {
        return this.metaService.register(eventMeshRegisterInfo);
    }

    public boolean unRegister(EventMeshUnRegisterInfo eventMeshUnRegisterInfo) throws MetaException {
        return this.metaService.unRegister(eventMeshUnRegisterInfo);
    }

    public List<EventMeshServicePubTopicInfo> findEventMeshServicePubTopicInfos() throws Exception {
        return this.metaService.findEventMeshServicePubTopicInfos();
    }

    public EventMeshAppSubTopicInfo findEventMeshAppSubTopicInfo(String group) throws Exception {
        return this.metaService.findEventMeshAppSubTopicInfoByGroup(group);
    }

    public Map<String, String> getMetaData(String key, boolean fuzzyEnabled) {
        return this.metaService.getMetaData(key, fuzzyEnabled);
    }

    public void getMetaDataWithListener(MetaServiceListener metaServiceListener, String key) throws Exception {
        this.metaService.getMetaDataWithListener(metaServiceListener, key);
    }

    public AtomicBoolean getInited() {
        return this.inited;
    }

    public AtomicBoolean getStarted() {
        return this.started;
    }
}

