/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.util;

import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolHelper {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolHelper.class);

    public static void printState(ThreadPoolExecutor threadPool) {
        if (threadPool == null) {
            log.warn("No thread pool is provided!");
            return;
        }
        log.info("The ThreadPool's state==================");
        log.info("Shutdown | Terminating | Terminated: {} | {} | {}", new Object[]{threadPool.isShutdown(), threadPool.isTerminating(), threadPool.isTerminated()});
        log.info("Active Threads: " + threadPool.getActiveCount());
        log.info("Completed Tasks / Tasks: {} / {}" + threadPool.getCompletedTaskCount(), (Object)threadPool.getTaskCount());
        log.info("Queue Size: " + threadPool.getQueue().size());
        log.info("Core Pool Size: " + threadPool.getCorePoolSize());
        log.info("Maximum Pool Size: " + threadPool.getMaximumPoolSize());
        log.info("Keep Alive Time(ms): " + threadPool.getKeepAliveTime(TimeUnit.MILLISECONDS));
        log.info("The rejection policy: " + threadPool.getRejectedExecutionHandler().getClass().getSimpleName());
        log.info("========================================");
    }
}

