/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.dingtalk.sink.connector;

import com.aliyun.dingtalkoauth2_1_0.Client;
import com.aliyun.dingtalkoauth2_1_0.models.GetAccessTokenRequest;
import com.aliyun.dingtalkrobot_1_0.models.OrgGroupSendHeaders;
import com.aliyun.dingtalkrobot_1_0.models.OrgGroupSendRequest;
import com.aliyun.tea.TeaException;
import com.aliyun.teautil.Common;
import com.aliyun.teautil.models.RuntimeOptions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.connector.dingtalk.config.DingDingMessageTemplateType;
import org.apache.eventmesh.connector.dingtalk.sink.config.DingDingSinkConfig;
import org.apache.eventmesh.openconnect.api.config.Config;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingDingSinkConnector
implements Sink {
    private static final Logger log = LoggerFactory.getLogger(DingDingSinkConnector.class);
    public static final Cache<String, String> AUTH_CACHE = CacheBuilder.newBuilder().initialCapacity(12).maximumSize(10L).concurrencyLevel(5).expireAfterWrite(20L, TimeUnit.MINUTES).build();
    public static final String ACCESS_TOKEN_CACHE_KEY = "access_token";
    private DingDingSinkConfig sinkConfig;
    private com.aliyun.dingtalkrobot_1_0.Client sendMessageClient;
    private Client authClient;
    private volatile boolean isRunning = false;

    public Class<? extends Config> configClass() {
        return DingDingSinkConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sinkConfig = (DingDingSinkConfig)config;
        this.sendMessageClient = DingDingSinkConnector.createSendMessageClient();
        this.authClient = DingDingSinkConnector.createOAuthClient();
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SinkConnectorContext sinkConnectorContext = (SinkConnectorContext)connectorContext;
        this.sinkConfig = (DingDingSinkConfig)sinkConnectorContext.getSinkConfig();
        this.sendMessageClient = DingDingSinkConnector.createSendMessageClient();
        this.authClient = DingDingSinkConnector.createOAuthClient();
    }

    public void start() {
        this.isRunning = true;
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sinkConfig.getSinkConnectorConfig().getConnectorName();
    }

    public void stop() {
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void put(List<ConnectRecord> sinkRecords) {
        for (ConnectRecord record : sinkRecords) {
            try {
                if (Objects.isNull(record.getData())) {
                    log.warn("ConnectRecord data is null, ignore.");
                    continue;
                }
                String accessToken = this.getAccessToken();
                OrgGroupSendHeaders orgGroupSendHeaders = new OrgGroupSendHeaders();
                orgGroupSendHeaders.xAcsDingtalkAccessToken = accessToken;
                String templateTypeKey = record.getExtension("dingtalktemplatetype");
                if (null == templateTypeKey || "null".equals(templateTypeKey)) {
                    templateTypeKey = DingDingMessageTemplateType.PLAIN_TEXT.getTemplateType();
                }
                DingDingMessageTemplateType templateType = DingDingMessageTemplateType.of(templateTypeKey);
                HashMap<String, String> contentMap = new HashMap<String, String>();
                if (DingDingMessageTemplateType.PLAIN_TEXT == templateType) {
                    contentMap.put("content", new String((byte[])record.getData()));
                } else if (DingDingMessageTemplateType.MARKDOWN == templateType) {
                    String title = Optional.ofNullable(record.getExtension("dingtalkmarkdownmessagetitle")).orElse("EventMesh-Message");
                    contentMap.put("title", title);
                    contentMap.put("text", new String((byte[])record.getData()));
                }
                OrgGroupSendRequest orgGroupSendRequest = new OrgGroupSendRequest().setMsgParam(JsonUtils.toJSONString(contentMap)).setMsgKey(templateType.getTemplateKey()).setOpenConversationId(this.sinkConfig.getSinkConnectorConfig().getOpenConversationId()).setRobotCode(this.sinkConfig.getSinkConnectorConfig().getRobotCode()).setCoolAppCode(this.sinkConfig.getSinkConnectorConfig().getCoolAppCode());
                try {
                    this.sendMessageClient.orgGroupSendWithOptions(orgGroupSendRequest, orgGroupSendHeaders, new RuntimeOptions());
                }
                catch (TeaException e) {
                    String errorMessage;
                    if (Common.empty((String)e.code) || Common.empty((String)e.message) || !"invalidParameter.token.invalid".equals(errorMessage = e.getMessage())) continue;
                    AUTH_CACHE.invalidate((Object)ACCESS_TOKEN_CACHE_KEY);
                }
            }
            catch (Exception e) {
                log.error("Failed to sink message to DingDing.", (Throwable)e);
            }
        }
    }

    private String getAccessToken() {
        return (String)AUTH_CACHE.get((Object)ACCESS_TOKEN_CACHE_KEY, () -> {
            GetAccessTokenRequest getAccessTokenRequest = new GetAccessTokenRequest().setAppKey(this.sinkConfig.getSinkConnectorConfig().getAppKey()).setAppSecret(this.sinkConfig.getSinkConnectorConfig().getAppSecret());
            return this.authClient.getAccessToken(getAccessTokenRequest).getBody().getAccessToken();
        });
    }

    public static com.aliyun.dingtalkrobot_1_0.Client createSendMessageClient() throws Exception {
        com.aliyun.teaopenapi.models.Config config = new com.aliyun.teaopenapi.models.Config();
        config.protocol = "https";
        config.regionId = "central";
        return new com.aliyun.dingtalkrobot_1_0.Client(config);
    }

    public static Client createOAuthClient() throws Exception {
        com.aliyun.teaopenapi.models.Config config = new com.aliyun.teaopenapi.models.Config();
        config.protocol = "https";
        config.regionId = "central";
        return new Client(config);
    }
}

