/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import lombok.Generated;

@Beta
public class KeyValueTableConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int partitionCount;
    private final int primaryKeyLength;
    private final int secondaryKeyLength;
    private final long rolloverSizeBytes;

    public int getTotalKeyLength() {
        return this.primaryKeyLength + this.secondaryKeyLength;
    }

    public String toString() {
        return String.format("Partitions = %s, KeyLength = %s:%s", this.partitionCount, this.primaryKeyLength, this.secondaryKeyLength);
    }

    @ConstructorProperties(value={"partitionCount", "primaryKeyLength", "secondaryKeyLength", "rolloverSizeBytes"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    KeyValueTableConfiguration(int partitionCount, int primaryKeyLength, int secondaryKeyLength, long rolloverSizeBytes) {
        this.partitionCount = partitionCount;
        this.primaryKeyLength = primaryKeyLength;
        this.secondaryKeyLength = secondaryKeyLength;
        this.rolloverSizeBytes = rolloverSizeBytes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static KeyValueTableConfigurationBuilder builder() {
        return new KeyValueTableConfigurationBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getPartitionCount() {
        return this.partitionCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getPrimaryKeyLength() {
        return this.primaryKeyLength;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getSecondaryKeyLength() {
        return this.secondaryKeyLength;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getRolloverSizeBytes() {
        return this.rolloverSizeBytes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyValueTableConfiguration)) {
            return false;
        }
        KeyValueTableConfiguration other = (KeyValueTableConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPartitionCount() != other.getPartitionCount()) {
            return false;
        }
        if (this.getPrimaryKeyLength() != other.getPrimaryKeyLength()) {
            return false;
        }
        if (this.getSecondaryKeyLength() != other.getSecondaryKeyLength()) {
            return false;
        }
        return this.getRolloverSizeBytes() == other.getRolloverSizeBytes();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeyValueTableConfiguration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPartitionCount();
        result = result * 59 + this.getPrimaryKeyLength();
        result = result * 59 + this.getSecondaryKeyLength();
        long $rolloverSizeBytes = this.getRolloverSizeBytes();
        result = result * 59 + (int)($rolloverSizeBytes >>> 32 ^ $rolloverSizeBytes);
        return result;
    }

    public static final class KeyValueTableConfigurationBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int partitionCount;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int primaryKeyLength;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int secondaryKeyLength;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long rolloverSizeBytes;

        public KeyValueTableConfiguration build() {
            Preconditions.checkArgument((this.partitionCount > 0 ? 1 : 0) != 0, (String)"partitionCount must be a positive integer. Given %s.", (int)this.partitionCount);
            Preconditions.checkArgument((this.primaryKeyLength > 0 ? 1 : 0) != 0, (String)"primaryKeyLength must be a positive integer. Given %s.", (int)this.primaryKeyLength);
            Preconditions.checkArgument((this.secondaryKeyLength >= 0 ? 1 : 0) != 0, (String)"secondaryKeyLength must be a non-negative integer. Given %s.", (int)this.secondaryKeyLength);
            Preconditions.checkArgument((this.rolloverSizeBytes >= 0L ? 1 : 0) != 0, (Object)String.format("Segment rollover size bytes cannot be less than 0, actual is %s", this.rolloverSizeBytes));
            return new KeyValueTableConfiguration(this.partitionCount, this.primaryKeyLength, this.secondaryKeyLength, this.rolloverSizeBytes);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        KeyValueTableConfigurationBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KeyValueTableConfigurationBuilder partitionCount(int partitionCount) {
            this.partitionCount = partitionCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KeyValueTableConfigurationBuilder primaryKeyLength(int primaryKeyLength) {
            this.primaryKeyLength = primaryKeyLength;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KeyValueTableConfigurationBuilder secondaryKeyLength(int secondaryKeyLength) {
            this.secondaryKeyLength = secondaryKeyLength;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KeyValueTableConfigurationBuilder rolloverSizeBytes(long rolloverSizeBytes) {
            this.rolloverSizeBytes = rolloverSizeBytes;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "KeyValueTableConfiguration.KeyValueTableConfigurationBuilder(partitionCount=" + this.partitionCount + ", primaryKeyLength=" + this.primaryKeyLength + ", secondaryKeyLength=" + this.secondaryKeyLength + ", rolloverSizeBytes=" + this.rolloverSizeBytes + ")";
        }
    }
}

