/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.beans.ConstructorProperties;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

class SegmentIteratorArgs {
    @NonNull
    private final ByteBuf fromKey;
    @NonNull
    private final ByteBuf toKey;
    private final int maxItemsAtOnce;

    SegmentIteratorArgs next(@Nullable ByteBuf lastKey) {
        if (lastKey == null) {
            return null;
        }
        byte[] result = lastKey.copy().array();
        ByteBuf resultBuf = null;
        for (int index = result.length - 1; index >= 0; --index) {
            int v = result[index] + 1 & 0xFF;
            result[index] = (byte)v;
            if (v == 0) continue;
            resultBuf = Unpooled.wrappedBuffer((byte[])result);
            break;
        }
        return resultBuf == null || resultBuf.compareTo(this.toKey) > 0 ? null : new SegmentIteratorArgs(resultBuf, this.toKey.copy(), this.maxItemsAtOnce);
    }

    @ConstructorProperties(value={"fromKey", "toKey", "maxItemsAtOnce"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    SegmentIteratorArgs(@NonNull ByteBuf fromKey, @NonNull ByteBuf toKey, int maxItemsAtOnce) {
        if (fromKey == null) {
            throw new NullPointerException("fromKey is marked non-null but is null");
        }
        if (toKey == null) {
            throw new NullPointerException("toKey is marked non-null but is null");
        }
        this.fromKey = fromKey;
        this.toKey = toKey;
        this.maxItemsAtOnce = maxItemsAtOnce;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static SegmentIteratorArgsBuilder builder() {
        return new SegmentIteratorArgsBuilder();
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ByteBuf getFromKey() {
        return this.fromKey;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ByteBuf getToKey() {
        return this.toKey;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxItemsAtOnce() {
        return this.maxItemsAtOnce;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SegmentIteratorArgs)) {
            return false;
        }
        SegmentIteratorArgs other = (SegmentIteratorArgs)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ByteBuf this$fromKey = this.getFromKey();
        ByteBuf other$fromKey = other.getFromKey();
        if (this$fromKey == null ? other$fromKey != null : !this$fromKey.equals(other$fromKey)) {
            return false;
        }
        ByteBuf this$toKey = this.getToKey();
        ByteBuf other$toKey = other.getToKey();
        if (this$toKey == null ? other$toKey != null : !this$toKey.equals(other$toKey)) {
            return false;
        }
        return this.getMaxItemsAtOnce() == other.getMaxItemsAtOnce();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SegmentIteratorArgs;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ByteBuf $fromKey = this.getFromKey();
        result = result * 59 + ($fromKey == null ? 43 : $fromKey.hashCode());
        ByteBuf $toKey = this.getToKey();
        result = result * 59 + ($toKey == null ? 43 : $toKey.hashCode());
        result = result * 59 + this.getMaxItemsAtOnce();
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "SegmentIteratorArgs(fromKey=" + this.getFromKey() + ", toKey=" + this.getToKey() + ", maxItemsAtOnce=" + this.getMaxItemsAtOnce() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class SegmentIteratorArgsBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ByteBuf fromKey;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ByteBuf toKey;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int maxItemsAtOnce;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SegmentIteratorArgsBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentIteratorArgsBuilder fromKey(@NonNull ByteBuf fromKey) {
            if (fromKey == null) {
                throw new NullPointerException("fromKey is marked non-null but is null");
            }
            this.fromKey = fromKey;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentIteratorArgsBuilder toKey(@NonNull ByteBuf toKey) {
            if (toKey == null) {
                throw new NullPointerException("toKey is marked non-null but is null");
            }
            this.toKey = toKey;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentIteratorArgsBuilder maxItemsAtOnce(int maxItemsAtOnce) {
            this.maxItemsAtOnce = maxItemsAtOnce;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentIteratorArgs build() {
            return new SegmentIteratorArgs(this.fromKey, this.toKey, this.maxItemsAtOnce);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "SegmentIteratorArgs.SegmentIteratorArgsBuilder(fromKey=" + this.fromKey + ", toKey=" + this.toKey + ", maxItemsAtOnce=" + this.maxItemsAtOnce + ")";
        }
    }
}

