/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.api;

import io.openmessaging.api.MessagingAccessPoint;
import io.openmessaging.api.internal.MessagingAccessPointAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class OMS {
    private final Properties properties = new Properties();
    public static String specVersion = "UnKnown";

    public static OMS builder() {
        return new OMS();
    }

    public OMS endpoint(String endpoint) {
        this.properties.put("endpoint", endpoint);
        return this;
    }

    public OMS schemaRegistryUrl(String schemaRegistryUrl) {
        this.properties.put("schemaRegistryUrl", schemaRegistryUrl);
        return this;
    }

    public OMS region(String region) {
        this.properties.put("region", region);
        return this;
    }

    public OMS driver(String driver) {
        this.properties.put("driver", driver);
        return this;
    }

    public OMS driverImpl(String driverImpl) {
        this.properties.put("driverImpl", driverImpl);
        return this;
    }

    public OMS withCredentials(Properties credentials) {
        if (credentials.getProperty("accessKey") != null) {
            this.properties.put("accessKey", credentials.getProperty("accessKey"));
        }
        if (credentials.getProperty("secretKey") != null) {
            this.properties.put("secretKey", credentials.getProperty("secretKey"));
        }
        if (credentials.getProperty("securityToken") != null) {
            this.properties.put("securityToken", credentials.getProperty("securityToken"));
        }
        return this;
    }

    public MessagingAccessPoint build() {
        return MessagingAccessPointAdapter.getMessagingAccessPoint(this.properties);
    }

    public MessagingAccessPoint build(Properties config) {
        Set<Map.Entry<Object, Object>> entrySet = config.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.properties.put(entry.getKey(), entry.getValue());
        }
        return MessagingAccessPointAdapter.getMessagingAccessPoint(this.properties);
    }

    private OMS() {
    }

    static {
        InputStream stream = OMS.class.getClassLoader().getResourceAsStream("oms.spec.properties");
        try {
            if (stream != null) {
                Properties properties = new Properties();
                properties.load(stream);
                specVersion = String.valueOf(properties.get("version"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

