/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.profiler.context.module.ConfiguredApplicationType;
import com.navercorp.pinpoint.profiler.plugin.PluginContextLoadResult;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApplicationServerTypeProvider
implements Provider<ServiceType> {
    private static final ServiceType DEFAULT_APPLICATION_TYPE = ServiceType.STAND_ALONE;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ProfilerConfig profilerConfig;
    private final ServiceType configuredApplicationType;
    private final Provider<PluginContextLoadResult> pluginContextLoadResultProvider;

    @Inject
    public ApplicationServerTypeProvider(ProfilerConfig profilerConfig, @ConfiguredApplicationType ServiceType configuredApplicationType, Provider<PluginContextLoadResult> pluginContextLoadResultProvider) {
        this.profilerConfig = Objects.requireNonNull(profilerConfig, "profilerConfig");
        this.configuredApplicationType = Objects.requireNonNull(configuredApplicationType, "configuredApplicationType");
        this.pluginContextLoadResultProvider = pluginContextLoadResultProvider;
    }

    public ServiceType get() {
        if (this.configuredApplicationType != ServiceType.UNDEFINED) {
            this.logger.info("Configured ApplicationServerType={}", (Object)this.configuredApplicationType);
            return this.configuredApplicationType;
        }
        PluginContextLoadResult pluginContextLoadResult = (PluginContextLoadResult)this.pluginContextLoadResultProvider.get();
        ServiceType resolvedApplicationType = pluginContextLoadResult.getApplicationType();
        if (resolvedApplicationType == null) {
            this.logger.info("Application type not resolved. Defaulting to {}", (Object)DEFAULT_APPLICATION_TYPE);
            return DEFAULT_APPLICATION_TYPE;
        }
        this.logger.info("Resolved Application type : {}", (Object)resolvedApplicationType);
        return resolvedApplicationType;
    }
}

