/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.recorder;

import com.navercorp.pinpoint.bootstrap.plugin.uri.UriExtractor;
import com.navercorp.pinpoint.bootstrap.plugin.uri.UriStatRecorder;
import com.navercorp.pinpoint.profiler.context.storage.UriStatStorage;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultUriStatRecorder<T>
implements UriStatRecorder<T> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final UriExtractor<T> uriExtractor;
    private final UriStatStorage uriStatStorage;

    public DefaultUriStatRecorder(UriExtractor<T> uriExtractor, UriStatStorage uriStatStorage) {
        this.uriExtractor = Objects.requireNonNull(uriExtractor, "uriExtractor");
        this.uriStatStorage = Objects.requireNonNull(uriStatStorage, "uriStatStorage");
    }

    public void record(T request, String rawUri, boolean status, long startTime, long endTime) {
        String uri = this.uriExtractor.getUri(request, rawUri);
        if (uri == null) {
            this.logger.warn("can not extract uri. request:{}, rawUri:{}", request, (Object)rawUri);
            return;
        }
        this.uriStatStorage.store(uri, status, endTime - startTime);
    }
}

