/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin;

import com.navercorp.pinpoint.profiler.plugin.PluginException;
import com.navercorp.pinpoint.profiler.plugin.PluginManifest;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarFile;

public class PluginJar {
    public static final String PINPOINT_PLUGIN_ID = "Pinpoint-Plugin-Id";
    public static final String PINPOINT_PLUGIN_PACKAGE = "Pinpoint-Plugin-Package";
    public static final String PINPOINT_PLUGIN_COMPILER_VERSION = "Pinpoint-Plugin-Compiler-Version";
    public static final String DEFAULT_PINPOINT_PLUGIN_PACKAGE_NAME = "com.navercorp.pinpoint.plugin";
    private final URL url;
    private final JarFile jarFile;
    private final PluginManifest manifest;

    private PluginJar(File file) {
        Objects.requireNonNull(file, "path");
        this.url = this.toURL(file);
        this.jarFile = PluginJar.createJarFile(file);
        this.manifest = PluginManifest.of(this.jarFile);
    }

    private URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new PluginException(file.getName() + " toURL error", e);
        }
    }

    private static JarFile createJarFile(File pluginJar) {
        try {
            PluginJar.verify(pluginJar);
            return new JarFile(pluginJar);
        }
        catch (IOException e) {
            throw new PluginException(pluginJar.getName() + " JarFile create error " + e.getCause(), e);
        }
    }

    public static PluginJar fromFilePath(String filePath) {
        File file = new File(filePath);
        return new PluginJar(file);
    }

    private static void verify(File file) {
        if (!file.exists()) {
            throw new PluginException(file + " File does not exist");
        }
        if (!file.isFile()) {
            throw new PluginException(file + " is not a file");
        }
        if (!file.canRead()) {
            throw new PluginException(file + " File cannot be read");
        }
    }

    public URL getURL() {
        return this.url;
    }

    public JarFile getJarFile() {
        return this.jarFile;
    }

    public String getPluginId() {
        return this.manifest.getPluginId();
    }

    public String getPluginCompilerVersion() {
        return this.manifest.getPluginCompilerVersion();
    }

    public List<String> getPluginPackages() {
        return this.manifest.getPluginPackages();
    }

    public String toString() {
        return "PluginJar{url=" + this.url + ", jarFile=" + this.jarFile + ", manifest=" + this.manifest + '}';
    }
}

