/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.receiver.service;

import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.common.util.ThreadMXBeanUtils;
import com.navercorp.pinpoint.profiler.receiver.ProfilerRequestCommandService;
import com.navercorp.pinpoint.thrift.dto.command.TCommandThreadDump;
import com.navercorp.pinpoint.thrift.dto.command.TCommandThreadDumpResponse;
import com.navercorp.pinpoint.thrift.dto.command.TMonitorInfo;
import com.navercorp.pinpoint.thrift.dto.command.TThreadDump;
import com.navercorp.pinpoint.thrift.dto.command.TThreadDumpType;
import com.navercorp.pinpoint.thrift.dto.command.TThreadState;
import com.navercorp.pinpoint.thrift.io.TCommandType;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TBase;

public class ThreadDumpService
implements ProfilerRequestCommandService<TBase<?, ?>, TBase<?, ?>> {
    private static final Set<TThreadState> THREAD_STATES = EnumSet.allOf(TThreadState.class);
    private final Logger logger = LogManager.getLogger(this.getClass());

    @Override
    public TBase<?, ?> requestCommandService(TBase<?, ?> tbase) {
        this.logger.info("{} execute {}.", (Object)this, tbase);
        TCommandThreadDump param = (TCommandThreadDump)tbase;
        TThreadDumpType type = param.getType();
        List<ThreadInfo> threadInfoList = this.getThreadInfos(type, param);
        List<TThreadDump> threadDumpList = this.getTThreadDumpList(threadInfoList);
        TCommandThreadDumpResponse response = new TCommandThreadDumpResponse();
        response.setThreadDumps(threadDumpList);
        return response;
    }

    private List<TThreadDump> getTThreadDumpList(List<ThreadInfo> threadInfoList) {
        ArrayList<TThreadDump> threadDumpList = new ArrayList<TThreadDump>(threadInfoList.size());
        for (ThreadInfo info : threadInfoList) {
            TThreadDump dump = this.toTThreadDump(info);
            threadDumpList.add(dump);
        }
        return threadDumpList;
    }

    private TThreadDump toTThreadDump(ThreadInfo info) {
        LockInfo[] lockInfos;
        MonitorInfo[] monitorInfos;
        StackTraceElement[] stackTraceElements;
        TThreadDump dump = new TThreadDump();
        dump.setThreadName(info.getThreadName());
        dump.setThreadId(info.getThreadId());
        dump.setBlockedTime(info.getBlockedTime());
        dump.setBlockedCount(info.getBlockedCount());
        dump.setWaitedTime(info.getWaitedTime());
        dump.setWaitedCount(info.getWaitedCount());
        dump.setLockName(info.getLockName());
        dump.setLockOwnerId(info.getLockOwnerId());
        dump.setLockOwnerName(info.getLockOwnerName());
        dump.setInNative(info.isInNative());
        dump.setSuspended(info.isSuspended());
        dump.setThreadState(this.getThreadState(info));
        for (StackTraceElement each : stackTraceElements = info.getStackTrace()) {
            dump.addToStackTrace(each.toString());
        }
        for (MonitorInfo each : monitorInfos = info.getLockedMonitors()) {
            TMonitorInfo tMonitorInfo = new TMonitorInfo();
            tMonitorInfo.setStackDepth(each.getLockedStackDepth());
            tMonitorInfo.setStackFrame(each.getLockedStackFrame().toString());
            dump.addToLockedMonitors(tMonitorInfo);
        }
        for (LockInfo lockInfo : lockInfos = info.getLockedSynchronizers()) {
            dump.addToLockedSynchronizers(lockInfo.toString());
        }
        return dump;
    }

    private List<ThreadInfo> getThreadInfos(TThreadDumpType type, TCommandThreadDump param) {
        if (TThreadDumpType.TARGET == type) {
            return this.getThreadInfo(param.getName());
        }
        if (TThreadDumpType.PENDING == type) {
            return this.getThreadInfo(param.getPendingTimeMillis());
        }
        return Arrays.asList(this.getAllThreadInfo());
    }

    private TThreadState getThreadState(ThreadInfo info) {
        String stateName = info.getThreadState().name();
        for (TThreadState state : THREAD_STATES) {
            if (!state.name().equalsIgnoreCase(stateName)) continue;
            return state;
        }
        return null;
    }

    private List<ThreadInfo> getThreadInfo(String threadName) {
        if (!StringUtils.hasText((String)threadName)) {
            return Arrays.asList(this.getAllThreadInfo());
        }
        ArrayList<ThreadInfo> result = new ArrayList<ThreadInfo>();
        for (ThreadInfo threadIno : this.getAllThreadInfo()) {
            if (!threadName.equals(threadIno.getThreadName())) continue;
            result.add(threadIno);
        }
        return result;
    }

    private List<ThreadInfo> getThreadInfo(long pendingTimeMillis) {
        if (pendingTimeMillis <= 0L) {
            return Arrays.asList(this.getAllThreadInfo());
        }
        ArrayList<ThreadInfo> result = new ArrayList<ThreadInfo>();
        for (ThreadInfo threadInfo : this.getAllThreadInfo()) {
            if (threadInfo.getBlockedTime() >= pendingTimeMillis) {
                result.add(threadInfo);
                continue;
            }
            if (threadInfo.getWaitedTime() < pendingTimeMillis) continue;
            result.add(threadInfo);
        }
        return result;
    }

    private ThreadInfo[] getAllThreadInfo() {
        ThreadInfo[] threadInfos = ThreadMXBeanUtils.dumpAllThread();
        return threadInfos;
    }

    @Override
    public short getCommandServiceCode() {
        return TCommandType.THREAD_DUMP.getCode();
    }
}

