/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.util;

import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.common.util.JvmVersion;
import java.lang.reflect.Method;

public final class PlatformClassLoaderUtils {
    private static final ClassLoader platformClassLoader = PlatformClassLoaderUtils.lookupPlatformOrBootstrapClassLoader();

    private PlatformClassLoaderUtils() {
    }

    private static ClassLoader lookupPlatformOrBootstrapClassLoader() {
        if (JvmUtils.getVersion().onOrAfter(JvmVersion.JAVA_9)) {
            return PlatformClassLoaderUtils.getPlatformClassLoader0();
        }
        return Object.class.getClassLoader();
    }

    private static ClassLoader getPlatformClassLoader0() {
        try {
            Method getPlatformClassLoader = ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]);
            return (ClassLoader)getPlatformClassLoader.invoke(ClassLoader.class, new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException("ClassLoader.getPlatformClassLoader() invoke fail Caused by:" + ex.getMessage(), ex);
        }
    }

    public static ClassLoader getPlatformOrBootstrapClassLoader() {
        return platformClassLoader;
    }

    public static Class<?> findClassFromPlatformClassLoader(String className) {
        try {
            return Class.forName(className, false, platformClassLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

