/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.meshmessage;

import com.google.common.base.Preconditions;
import io.cloudevents.CloudEvent;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEventBatch;
import org.apache.eventmesh.common.protocol.grpc.common.BatchEventMeshCloudEventWrapper;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventWrapper;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.tcp.EventMeshMessage;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.exception.ProtocolHandleException;
import org.apache.eventmesh.protocol.meshmessage.resolver.grpc.GrpcEventMeshCloudEventProtocolResolver;
import org.apache.eventmesh.protocol.meshmessage.resolver.http.SendMessageBatchProtocolResolver;
import org.apache.eventmesh.protocol.meshmessage.resolver.http.SendMessageBatchV2ProtocolResolver;
import org.apache.eventmesh.protocol.meshmessage.resolver.http.SendMessageRequestProtocolResolver;
import org.apache.eventmesh.protocol.meshmessage.resolver.tcp.TcpMessageProtocolResolver;

public class MeshMessageProtocolAdaptor
implements ProtocolAdaptor<ProtocolTransportObject> {
    public CloudEvent toCloudEvent(ProtocolTransportObject protocol) throws ProtocolHandleException {
        if (protocol instanceof Package) {
            Package tcpPackage = (Package)protocol;
            Header header = tcpPackage.getHeader();
            String bodyJson = (String)tcpPackage.getBody();
            return this.deserializeTcpProtocol(header, bodyJson);
        }
        if (protocol instanceof HttpCommand) {
            org.apache.eventmesh.common.protocol.http.header.Header header = ((HttpCommand)protocol).getHeader();
            Body body = ((HttpCommand)protocol).getBody();
            String requestCode = ((HttpCommand)protocol).getRequestCode();
            return this.deserializeHttpProtocol(requestCode, header, body);
        }
        if (protocol instanceof EventMeshCloudEventWrapper) {
            EventMeshCloudEventWrapper wrapper = (EventMeshCloudEventWrapper)protocol;
            return GrpcEventMeshCloudEventProtocolResolver.buildEvent(wrapper.getMessage());
        }
        throw new ProtocolHandleException(String.format("protocol class: %s", protocol.getClass()));
    }

    private CloudEvent deserializeTcpProtocol(Header header, String bodyJson) throws ProtocolHandleException {
        return TcpMessageProtocolResolver.buildEvent(header, (EventMeshMessage)JsonUtils.parseObject((String)bodyJson, EventMeshMessage.class));
    }

    private CloudEvent deserializeHttpProtocol(String requestCode, org.apache.eventmesh.common.protocol.http.header.Header header, Body body) throws ProtocolHandleException {
        if (String.valueOf(RequestCode.MSG_BATCH_SEND.getRequestCode()).equals(requestCode)) {
            return SendMessageBatchProtocolResolver.buildEvent(header, body);
        }
        if (String.valueOf(RequestCode.MSG_BATCH_SEND_V2.getRequestCode()).equals(requestCode)) {
            return SendMessageBatchV2ProtocolResolver.buildEvent(header, body);
        }
        if (String.valueOf(RequestCode.MSG_SEND_SYNC.getRequestCode()).equals(requestCode)) {
            return SendMessageRequestProtocolResolver.buildEvent(header, body);
        }
        if (String.valueOf(RequestCode.MSG_SEND_ASYNC.getRequestCode()).equals(requestCode)) {
            return SendMessageRequestProtocolResolver.buildEvent(header, body);
        }
        throw new ProtocolHandleException(String.format("unsupported requestCode: %s", requestCode));
    }

    public List<CloudEvent> toBatchCloudEvent(ProtocolTransportObject protocol) throws ProtocolHandleException {
        if (protocol instanceof BatchEventMeshCloudEventWrapper) {
            CloudEventBatch cloudEventBatch = ((BatchEventMeshCloudEventWrapper)protocol).getMessage();
            return GrpcEventMeshCloudEventProtocolResolver.buildBatchEvents(cloudEventBatch);
        }
        throw new ProtocolHandleException(String.format("protocol class: %s", protocol.getClass()));
    }

    public ProtocolTransportObject fromCloudEvent(final CloudEvent cloudEvent) throws ProtocolHandleException {
        String protocolDesc;
        this.validateCloudEvent(cloudEvent);
        String string = protocolDesc = cloudEvent.getExtension("protocoldesc") == null ? null : cloudEvent.getExtension("protocoldesc").toString();
        if (StringUtils.equals((CharSequence)"http", (CharSequence)protocolDesc)) {
            HttpCommand httpCommand = new HttpCommand();
            Body body = new Body(){
                final Map<String, Object> map = new HashMap<String, Object>();

                public Map<String, Object> toMap() {
                    if (cloudEvent.getData() == null) {
                        return this.map;
                    }
                    this.map.put("content", new String(cloudEvent.getData().toBytes(), StandardCharsets.UTF_8));
                    return this.map;
                }
            };
            body.toMap();
            httpCommand.setBody(body);
            return httpCommand;
        }
        if (StringUtils.equals((CharSequence)"tcp", (CharSequence)protocolDesc)) {
            return TcpMessageProtocolResolver.buildEventMeshMessage(cloudEvent);
        }
        if (StringUtils.equals((CharSequence)"grpc-cloud-event", (CharSequence)protocolDesc)) {
            return GrpcEventMeshCloudEventProtocolResolver.buildEventMeshCloudEvent(cloudEvent);
        }
        throw new ProtocolHandleException(String.format("Unsupported protocolDesc: %s", protocolDesc));
    }

    public String getProtocolType() {
        return "eventmeshmessage";
    }

    private void validateCloudEvent(CloudEvent cloudEvent) {
        Preconditions.checkNotNull((Object)cloudEvent, (Object)"CloudEvent cannot be null");
    }
}

