/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.enums.HttpMethod;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.admin.controller.HttpHandlerManager;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.admin.request.DeleteHTTPClientRequest;
import org.apache.eventmesh.runtime.admin.response.Error;
import org.apache.eventmesh.runtime.admin.response.GetClientResponse;
import org.apache.eventmesh.runtime.admin.utils.HttpExchangeUtils;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.common.EventHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventHttpHandler(path="/client/http")
public class HTTPClientHandler
extends AbstractHttpHandler {
    private static final Logger log = LoggerFactory.getLogger(HTTPClientHandler.class);
    private final EventMeshHTTPServer eventMeshHTTPServer;

    public HTTPClientHandler(EventMeshHTTPServer eventMeshHTTPServer, HttpHandlerManager httpHandlerManager) {
        super(httpHandlerManager);
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    void preflight(HttpExchange httpExchange) throws IOException {
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Methods", "*");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Headers", "*");
        httpExchange.getResponseHeaders().add("Access-Control-Max-Age", "86400");
        httpExchange.sendResponseHeaders(200, 0L);
        OutputStream out = httpExchange.getResponseBody();
        out.close();
    }

    void delete(HttpExchange httpExchange) throws IOException {
        try (OutputStream out = httpExchange.getResponseBody();){
            String request = HttpExchangeUtils.streamToString(httpExchange.getRequestBody());
            DeleteHTTPClientRequest deleteHTTPClientRequest = (DeleteHTTPClientRequest)JsonUtils.parseObject((String)request, DeleteHTTPClientRequest.class);
            String url = Objects.requireNonNull(deleteHTTPClientRequest).getUrl();
            for (List<Client> clientList : this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping().values()) {
                clientList.removeIf(client -> Objects.equals(client.getUrl(), url));
            }
            httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
            httpExchange.sendResponseHeaders(200, 0L);
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            e.printStackTrace(printWriter);
            printWriter.flush();
            String stackTrace = writer.toString();
            Error error = new Error(e.toString(), stackTrace);
            String result = JsonUtils.toJSONString((Object)error);
            httpExchange.sendResponseHeaders(500, 0L);
            log.error(result, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void list(HttpExchange httpExchange) throws IOException {
        OutputStream out = httpExchange.getResponseBody();
        httpExchange.getResponseHeaders().add("Content-Type", "application/json");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
        try {
            ArrayList<GetClientResponse> getClientResponseList = new ArrayList<GetClientResponse>();
            for (List<Client> clientList : this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping().values()) {
                for (Client client : clientList) {
                    GetClientResponse getClientResponse = new GetClientResponse(Optional.ofNullable(client.getEnv()).orElse(""), Optional.ofNullable(client.getSys()).orElse(""), Optional.ofNullable(client.getUrl()).orElse(""), "0", Optional.ofNullable(client.getHostname()).orElse(""), 0, Optional.ofNullable(client.getApiVersion()).orElse(""), Optional.ofNullable(client.getIdc()).orElse(""), Optional.ofNullable(client.getConsumerGroup()).orElse(""), "", "http".toUpperCase());
                    getClientResponseList.add(getClientResponse);
                }
            }
            getClientResponseList.sort((lhs, rhs) -> {
                if (lhs.getHost().equals(rhs.getHost())) {
                    return lhs.getHost().compareTo(rhs.getHost());
                }
                return Integer.compare(rhs.getPort(), lhs.getPort());
            });
            String result = JsonUtils.toJSONString(getClientResponseList);
            httpExchange.sendResponseHeaders(200, Objects.requireNonNull(result).getBytes(Constants.DEFAULT_CHARSET).length);
            out.write(result.getBytes(Constants.DEFAULT_CHARSET));
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            e.printStackTrace(printWriter);
            printWriter.flush();
            String stackTrace = writer.toString();
            Error error = new Error(e.toString(), stackTrace);
            String result = JsonUtils.toJSONString((Object)error);
            httpExchange.sendResponseHeaders(500, Objects.requireNonNull(result).getBytes(Constants.DEFAULT_CHARSET).length);
            out.write(result.getBytes(Constants.DEFAULT_CHARSET));
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.warn("out close failed...", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        switch (HttpMethod.valueOf((String)httpExchange.getRequestMethod())) {
            case OPTIONS: {
                this.preflight(httpExchange);
                break;
            }
            case GET: {
                this.list(httpExchange);
                break;
            }
            case DELETE: {
                this.delete(httpExchange);
                break;
            }
        }
    }
}

